<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TournamentMatch extends Model
{
    use HasFactory;

    protected $fillable = [
        'tournament_id',
        'round',
        'player_a_id',
        'player_b_id',
        'result',
        'dispute_id',
    ];

    /**
     * The tournament this match belongs to
     */
    public function tournament(): BelongsTo
    {
        return $this->belongsTo(Tournament::class);
    }

    /**
     * Player A
     */
    public function playerA(): BelongsTo
    {
        return $this->belongsTo(User::class, 'player_a_id');
    }

    /**
     * Player B
     */
    public function playerB(): BelongsTo
    {
        return $this->belongsTo(User::class, 'player_b_id');
    }

    /**
     * Related dispute (if any)
     */
    public function dispute(): BelongsTo
    {
        return $this->belongsTo(Dispute::class);
    }

    /**
     * Get the winner of the match
     */
    public function getWinner(): ?User
    {
        if ($this->result === 'player_a_win') {
            return $this->playerA;
        } elseif ($this->result === 'player_b_win') {
            return $this->playerB;
        }
        
        return null;
    }
}