<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class EmailVerificationReminder extends Notification implements ShouldQueue
{
    use Queueable;

    /**
     * Get the notification's delivery channels.
     *
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     */
    public function toMail(object $notifiable): MailMessage
    {
        return (new MailMessage)
            ->subject('Verify Your Email Address - BattleMania')
            ->greeting("Hello {$notifiable->username}!")
            ->line('Please verify your email address to complete your account setup and unlock all features.')
            ->line('Email verification helps us:')
            ->line('• Secure your account')
            ->line('• Send important notifications about your challenges and tournaments')
            ->line('• Enable password recovery')
            ->action('Verify Email Address', url(route('verification.verify', [
                'id' => $notifiable->getKey(),
                'hash' => sha1($notifiable->getEmailForVerification()),
            ])))
            ->line('If you did not create an account, no further action is required.')
            ->salutation('Best regards, The BattleMania Team');
    }

    /**
     * Get the array representation of the notification.
     *
     * @return array<string, mixed>
     */
    public function toArray(object $notifiable): array
    {
        return [
            'type' => 'email_verification_reminder',
            'user_id' => $notifiable->id,
            'email' => $notifiable->email,
        ];
    }
}
