<?php

namespace App\Policies;

use App\Models\Tournament;
use App\Models\User;
use Illuminate\Auth\Access\Response;

class TournamentPolicy
{
    /**
     * Determine whether the user can view any models.
     */
    public function viewAny(User $user): bool
    {
        return true; // Anyone can view tournaments
    }

    /**
     * Determine whether the user can view the model.
     */
    public function view(User $user, Tournament $tournament): bool
    {
        return true; // Anyone can view a tournament
    }

    /**
     * Determine whether the user can create models.
     * Uses existing user methods that check level 29+ OR creator role OR admin
     * Moderator role does NOT bypass level requirements
     */
    public function create(User $user): bool
    {
        // Use the existing method that properly checks level-based permissions
        return $user->canCreateTournaments();
    }

    /**
     * Determine whether the user can update the model.
     */
    public function update(User $user, Tournament $tournament): bool
    {
        // Only host of the tournament can update it, or admins
        return $user->id === $tournament->host_id || $user->is_organizer;
    }

    /**
     * Determine whether the user can delete the model.
     */
    public function delete(User $user, Tournament $tournament): bool
    {
        // Only host of the tournament can delete it, or admins
        return $user->id === $tournament->host_id || $user->is_organizer;
    }

    /**
     * Determine whether the user can restore the model.
     */
    public function restore(User $user, Tournament $tournament): bool
    {
        return $user->is_organizer;
    }

    /**
     * Determine whether the user can permanently delete the model.
     */
    public function forceDelete(User $user, Tournament $tournament): bool
    {
        return $user->is_organizer;
    }
}
