<?php

use Illuminate\Foundation\Application;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    ->withRouting(
        web: __DIR__.'/../routes/web.php',
        api: __DIR__.'/../routes/api.php',
        commands: __DIR__.'/../routes/console.php',
        health: '/up',
    )
    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'check.level' => \App\Http\Middleware\CheckLevel::class,
            'admin' => \App\Http\Middleware\AdminMiddleware::class,
            'role' => \App\Http\Middleware\EnsureUserRole::class,
        ]);
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })
    ->withProviders([
        // Register the policies
    ])
    ->booted(function () {
        // Register view composers
        \Illuminate\Support\Facades\View::composer('layouts.admin', \App\Http\View\Composers\AdminStatsComposer::class);
        \Illuminate\Support\Facades\View::composer('layouts.app', \App\Http\View\Composers\PlatformSettingsComposer::class);
    })
    ->create();