<?php

namespace Database\Factories;

use App\Models\Challenge;
use App\Models\Game;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Challenge>
 */
class ChallengeFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'creator_id' => User::factory(),
            'accepter_id' => fake()->boolean(70) ? User::factory() : null,
            'game_id' => Game::factory(),
            'wager_amount' => fake()->randomElement([100, 250, 500, 1000, 2500, 5000]),
            'best_of' => fake()->randomElement([1, 3, 5]),
            'rules_text' => fake()->optional()->paragraph(),
            'status' => fake()->randomElement(['open', 'accepted', 'completed', 'disputed']),
            'result' => function (array $attributes) {
                if (in_array($attributes['status'], ['completed', 'disputed'])) {
                    return fake()->randomElement(['creator_win', 'accepter_win', 'none']);
                }
                return 'none';
            },
        ];
    }

    /**
     * Indicate that the challenge is open.
     */
    public function open(): static
    {
        return $this->state(fn (array $attributes) => [
            'accepter_id' => null,
            'status' => 'open',
            'result' => 'none',
        ]);
    }

    /**
     * Indicate that the challenge is completed.
     */
    public function completed(): static
    {
        return $this->state(fn (array $attributes) => [
            'accepter_id' => User::factory(),
            'status' => 'completed',
            'result' => fake()->randomElement(['creator_win', 'accepter_win']),
        ]);
    }
}