<?php

namespace Database\Factories;

use App\Models\Game;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Game>
 */
class GameFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        $name = fake()->randomElement([
            'Call of Duty Mobile',
            'PUBG Mobile',
            'FIFA Mobile',
            'Free Fire',
            'Fortnite',
            'Valorant',
            'League of Legends',
            'FIFA 24'
        ]);

        return [
            'name' => $name,
            'slug' => \Str::slug($name),
            'platform' => fake()->randomElement(['mobile', 'pc', 'console']),
        ];
    }
}