<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\User>
 */
class UserFactory extends Factory
{
    /**
     * The current password being used by the factory.
     */
    protected static ?string $password;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'username' => fake()->unique()->userName(),
            'email' => fake()->unique()->safeEmail(),
            'email_verified_at' => now(),
            'password' => static::$password ??= Hash::make('password'),
            'remember_token' => Str::random(10),
            'xp' => fake()->numberBetween(0, 1000),
            'games_played' => fake()->numberBetween(0, 100),
            'level' => fake()->numberBetween(1, 5),
            'wallet_balance' => fake()->randomFloat(2, 0, 10000),
            'locked_balance' => 0,
            'kyc_status' => fake()->randomElement(['none', 'pending', 'verified']),
            'agreement_rate' => fake()->randomFloat(2, 0.7, 1.0),
            'strike_count' => fake()->numberBetween(0, 3),
            'is_organizer' => fake()->boolean(10), // 10% chance of being organizer
            'role' => fake()->randomElement(['basic_user', 'premium_user', 'creator', 'moderator']),
            'status' => fake()->randomElement(['active', 'banned']),
        ];
    }

    /**
     * Indicate that the model's email address should be unverified.
     */
    public function unverified(): static
    {
        return $this->state(fn (array $attributes) => [
            'email_verified_at' => null,
        ]);
    }

    /**
     * Indicate that the user is an organizer.
     */
    public function organizer(): static
    {
        return $this->state(fn (array $attributes) => [
            'is_organizer' => true,
            'kyc_status' => 'verified',
            'level' => 5,
            'xp' => fake()->numberBetween(1000, 5000),
        ]);
    }
}