<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('users', function (Blueprint $table) {
            $table->id();
            $table->string('username')->unique();
            $table->string('email')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->string('avatar_url')->nullable();
            
            // Gaming & XP System
            $table->integer('xp')->default(0);
            $table->integer('level')->default(1);
            
            // Wallet
            $table->decimal('wallet_balance', 10, 2)->default(0);
            $table->decimal('locked_balance', 10, 2)->default(0);
            
            // KYC & Status
            $table->enum('kyc_status', ['none', 'pending', 'verified'])->default('none');
            $table->decimal('agreement_rate', 3, 2)->default(0); // 0-1 scale
            $table->integer('strike_count')->default(0);
            
            // Permissions
            $table->boolean('is_organizer')->default(false);
            $table->enum('status', ['active', 'banned'])->default('active');
            
            $table->rememberToken();
            $table->timestamps();
        });

        Schema::create('password_reset_tokens', function (Blueprint $table) {
            $table->string('email')->primary();
            $table->string('token');
            $table->timestamp('created_at')->nullable();
        });

        Schema::create('sessions', function (Blueprint $table) {
            $table->string('id')->primary();
            $table->foreignId('user_id')->nullable()->index();
            $table->string('ip_address', 45)->nullable();
            $table->text('user_agent')->nullable();
            $table->longText('payload');
            $table->integer('last_activity')->index();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('users');
        Schema::dropIfExists('password_reset_tokens');
        Schema::dropIfExists('sessions');
    }
};