<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('levels', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->integer('min_xp');
            $table->integer('min_matches')->default(0);
            $table->decimal('min_agreement_rate', 3, 2)->default(0); // 0-1 scale
            
            // Permissions
            $table->boolean('requires_kyc')->default(false);
            $table->boolean('can_create_challenges')->default(true);
            $table->boolean('can_host_free_tournaments')->default(false);
            $table->boolean('can_host_paid_tournaments')->default(false);
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('levels');
    }
};