<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('challenges', function (Blueprint $table) {
            $table->id();
            $table->foreignId('creator_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('accepter_id')->nullable()->constrained('users')->onDelete('cascade');
            $table->foreignId('game_id')->constrained()->onDelete('cascade');
            
            $table->decimal('wager_amount', 10, 2);
            $table->integer('best_of')->default(1); // best of X matches
            $table->text('rules_text')->nullable();
            
            $table->enum('status', ['open', 'accepted', 'completed', 'disputed'])->default('open');
            $table->enum('result', ['creator_win', 'accepter_win', 'none'])->default('none');
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('challenges');
    }
};