<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tournaments', function (Blueprint $table) {
            $table->id();
            $table->foreignId('host_id')->constrained('users')->onDelete('cascade');
            $table->foreignId('game_id')->constrained()->onDelete('cascade');
            
            $table->enum('type', ['knockout', 'round_robin']);
            $table->string('title');
            $table->text('description')->nullable();
            
            $table->decimal('entry_fee', 10, 2)->default(0);
            $table->decimal('prize_pool', 10, 2)->default(0);
            $table->string('livestream_link')->nullable();
            
            $table->enum('status', ['upcoming', 'ongoing', 'completed'])->default('upcoming');
            $table->json('bracket_json')->nullable(); // Store tournament bracket structure
            
            $table->datetime('starts_at')->nullable();
            $table->datetime('ends_at')->nullable();
            
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tournaments');
    }
};