<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('challenges', function (Blueprint $table) {
            // MySQL indexes for optimal leaderboard query performance
            $table->index(['creator_id', 'result', 'status'], 'idx_creator_result_status');
            $table->index(['accepter_id', 'result', 'status'], 'idx_accepter_result_status');
            $table->index(['creator_id', 'result', 'status', 'updated_at'], 'idx_creator_result_status_date');
            $table->index(['accepter_id', 'result', 'status', 'updated_at'], 'idx_accepter_result_status_date');
        });

        Schema::table('users', function (Blueprint $table) {
            // Index for user status filtering
            $table->index('status', 'idx_user_status');
        });

        Schema::table('wallet_transactions', function (Blueprint $table) {
            // Index for winnings leaderboard queries
            $table->index(['user_id', 'type', 'status'], 'idx_user_type_status');
            $table->index(['user_id', 'type', 'status', 'created_at'], 'idx_user_type_status_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('challenges', function (Blueprint $table) {
            $table->dropIndex('idx_creator_result_status');
            $table->dropIndex('idx_accepter_result_status');
            $table->dropIndex('idx_creator_result_status_date');
            $table->dropIndex('idx_accepter_result_status_date');
        });

        Schema::table('users', function (Blueprint $table) {
            $table->dropIndex('idx_user_status');
        });

        Schema::table('wallet_transactions', function (Blueprint $table) {
            $table->dropIndex('idx_user_type_status');
            $table->dropIndex('idx_user_type_status_date');
        });
    }
};