<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notification_providers', function (Blueprint $table) {
            $table->id();
            $table->string('name'); // Provider name (resend, termii, mailgun, etc.)
            $table->enum('type', ['email', 'sms']); // Provider type
            $table->string('display_name'); // Display name for admin panel
            $table->json('configuration'); // Provider-specific configuration
            $table->boolean('is_active')->default(false); // Whether provider is active
            $table->boolean('is_default')->default(false); // Whether this is the default provider for the type
            $table->integer('priority')->default(1); // Priority for fallback (1 = highest)
            $table->json('test_results')->nullable(); // Last test results
            $table->timestamp('last_tested_at')->nullable();
            $table->timestamps();

            $table->unique(['name', 'type']); // Each provider can only exist once per type
            $table->index(['type', 'is_active', 'priority']); // For efficient provider selection
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notification_providers');
    }
};
