<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notification_settings', function (Blueprint $table) {
            $table->id();
            $table->string('key')->unique(); // Setting key (e.g., 'default_email_provider', 'email_enabled')
            $table->text('value')->nullable(); // Setting value
            $table->text('description')->nullable(); // Human-readable description
            $table->enum('type', ['string', 'boolean', 'integer', 'json'])->default('string'); // Value type
            $table->timestamps();

            $table->index('key'); // For efficient setting retrieval
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notification_settings');
    }
};
