<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('challenges', function (Blueprint $table) {
            // Add fields for challenger's in-game username and group/lobby information
            $table->string('creator_game_username')->after('creator_id');
            $table->string('group_link')->nullable()->after('creator_game_username');
            $table->string('group_id')->nullable()->after('group_link');
            
            // Add fields to track individual player results for better confirmation flow
            $table->enum('creator_claimed_result', ['win', 'loss', 'none'])->default('none')->after('result');
            $table->enum('accepter_claimed_result', ['win', 'loss', 'none'])->default('none')->after('creator_claimed_result');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('challenges', function (Blueprint $table) {
            $table->dropColumn([
                'creator_game_username',
                'group_link', 
                'group_id',
                'creator_claimed_result',
                'accepter_claimed_result'
            ]);
        });
    }
};
