<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('disputes', function (Blueprint $table) {
            // Add evidence fields for when both players claim victory
            $table->string('creator_evidence_path')->nullable()->after('reason');
            $table->string('accepter_evidence_path')->nullable()->after('creator_evidence_path');
            $table->boolean('admin_notified')->default(false)->after('accepter_evidence_path');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('disputes', function (Blueprint $table) {
            $table->dropColumn([
                'creator_evidence_path',
                'accepter_evidence_path', 
                'admin_notified'
            ]);
        });
    }
};
