<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->integer('games_played')->default(0)->after('xp');
            $table->enum('creator_request_status', ['none', 'pending', 'approved', 'rejected'])->default('none')->after('role');
            $table->timestamp('creator_request_date')->nullable()->after('creator_request_status');
            $table->text('creator_request_reason')->nullable()->after('creator_request_date');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropColumn(['games_played', 'creator_request_status', 'creator_request_date', 'creator_request_reason']);
        });
    }
};
