<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('wallet_transactions', function (Blueprint $table) {
            // Update the enum to include admin transaction types
            $table->enum('type', [
                'deposit', 
                'withdraw', 
                'wager', 
                'prize', 
                'fee', 
                'refund', 
                'transfer', 
                'transfer_received', 
                'admin_credit', 
                'admin_debit', 
                'admin_action'
            ])->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('wallet_transactions', function (Blueprint $table) {
            // Revert back to previous enum values
            $table->enum('type', ['deposit', 'withdraw', 'wager', 'prize', 'fee', 'refund', 'transfer', 'transfer_received'])->change();
        });
    }
};