<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop existing role column
            $table->dropColumn('role');
        });
        
        Schema::table('users', function (Blueprint $table) {
            // Add new role enum with 5 roles
            $table->enum('role', ['basic_user', 'premium_user', 'creator', 'moderator', 'admin'])
                  ->default('basic_user')
                  ->after('is_organizer');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            // Drop new role column
            $table->dropColumn('role');
        });
        
        Schema::table('users', function (Blueprint $table) {
            // Restore old role enum
            $table->enum('role', ['level1', 'level2', 'highest', 'creator', 'admin'])
                  ->default('level1')
                  ->after('is_organizer');
        });
    }
};
