<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('disputes', function (Blueprint $table) {
            // Add moderator assignment
            $table->foreignId('moderator_id')->nullable()->after('admin_id')->constrained('users')->onDelete('set null');
            $table->timestamp('assigned_to_moderator_at')->nullable()->after('moderator_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('disputes', function (Blueprint $table) {
            $table->dropForeign(['moderator_id']);
            $table->dropColumn(['moderator_id', 'assigned_to_moderator_at']);
        });
    }
};
