<?php

namespace Database\Seeders;

use App\Models\Post;
use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class BlogPostSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create an admin user if doesn't exist
        $admin = User::where('is_organizer', true)->first();
        if (!$admin) {
            $admin = User::create([
                'username' => 'admin',
                'email' => 'admin@battlemania.com',
                'phone' => '+1234567890',
                'password' => bcrypt('password'),
                'is_organizer' => true,
                'role' => 'creator',
                'kyc_status' => 'verified',
                'wallet_balance' => 10000,
                'xp' => 5000,
                'level' => 5,
            ]);
        }

        // Create sample blog posts
        $posts = [
            [
                'title' => 'Welcome to BattleMania - The Ultimate Gaming Challenge Platform',
                'content' => '
<p>Welcome to BattleMania, where gaming dreams become reality and every match is a chance to prove your skills!</p>

<p>Our platform is designed for serious gamers who want to compete, earn, and build their reputation in the gaming community. Whether you\'re a casual player looking to test your skills or a professional esports athlete, BattleMania provides the perfect arena for competitive gaming.</p>

<h3>What Makes BattleMania Special?</h3>
<ul>
<li><strong>Real Money Competitions:</strong> Put your money where your skill is and compete for real cash prizes</li>
<li><strong>Multiple Game Support:</strong> From FPS games to strategy games, we support a wide variety of popular titles</li>
<li><strong>Fair Play Guarantee:</strong> Our advanced dispute resolution system ensures fair play for all participants</li>
<li><strong>Community Features:</strong> Connect with fellow gamers, build your network, and create lasting gaming friendships</li>
</ul>

<p>Join thousands of gamers who have already discovered the thrill of competitive gaming with real stakes. Your journey to gaming glory starts here!</p>
                ',
                'excerpt' => 'Discover BattleMania, the ultimate gaming challenge platform where serious gamers compete for real money prizes.',
                'type' => Post::TYPE_BLOG,
            ],
            [
                'title' => '10 Pro Tips to Dominate Your Gaming Challenges',
                'content' => '
<p>Want to increase your win rate and climb the leaderboards? Here are 10 essential tips from our top-performing players:</p>

<h3>1. Master Your Main Game</h3>
<p>Focus on becoming exceptional at one game rather than being mediocre at many. Deep knowledge of game mechanics, maps, and strategies will give you a significant advantage.</p>

<h3>2. Practice in Unranked Before Betting</h3>
<p>Always warm up and practice in unranked or casual modes before entering paid challenges. Your reflexes and decision-making improve significantly after a few warm-up games.</p>

<h3>3. Know Your Limits</h3>
<p>Never bet more than you can afford to lose. Start with smaller wagers and gradually increase as you build confidence and skills.</p>

<h3>4. Study Your Opponents</h3>
<p>Check your opponent\'s gaming history, win rate, and favorite strategies. Knowledge is power in competitive gaming.</p>

<h3>5. Optimize Your Gaming Setup</h3>
<p>Invest in good peripherals: a responsive mouse, mechanical keyboard, and high-refresh monitor can make the difference between victory and defeat.</p>

<h3>6. Stay Calm Under Pressure</h3>
<p>Manage your emotions during high-stakes matches. Take deep breaths, stay focused, and don\'t let frustration cloud your judgment.</p>

<h3>7. Learn from Defeats</h3>
<p>Review your losses and identify areas for improvement. Every defeat is a learning opportunity that can make you stronger.</p>

<h3>8. Build a Gaming Schedule</h3>
<p>Consistency is key. Set regular practice times and stick to them. Treat gaming seriously if you want serious results.</p>

<h3>9. Join Gaming Communities</h3>
<p>Connect with other players, share strategies, and learn from experienced gamers. The gaming community is usually welcoming to those who show respect and dedication.</p>

<h3>10. Manage Your Bankroll</h3>
<p>Keep track of your wins and losses. Set daily/weekly limits and never chase losses with bigger bets.</p>

<p>Remember, becoming a top competitive gamer takes time, practice, and dedication. Apply these tips consistently, and you\'ll see improvement in your gameplay and earnings!</p>
                ',
                'excerpt' => 'Learn essential strategies and tips from top BattleMania players to improve your competitive gaming performance.',
                'type' => Post::TYPE_BLOG,
            ],
            [
                'title' => 'The Rise of Mobile Gaming in Competitive Esports',
                'content' => '
<p>Mobile gaming has evolved from casual entertainment to serious competitive sport. Here\'s how mobile esports is changing the gaming landscape:</p>

<h3>Mobile Gaming Statistics</h3>
<p>The mobile gaming industry has exploded in recent years:</p>
<ul>
<li>Over 3 billion mobile gamers worldwide</li>
<li>Mobile games generate more revenue than PC and console combined</li>
<li>Professional mobile gaming tournaments with million-dollar prize pools</li>
<li>Major esports organizations now have dedicated mobile gaming divisions</li>
</ul>

<h3>Why Mobile Gaming is Perfect for Competition</h3>
<p><strong>Accessibility:</strong> Anyone with a smartphone can compete, removing barriers to entry that traditionally existed in PC gaming.</p>

<p><strong>Innovation:</strong> Mobile games often feature unique mechanics and gameplay styles that create fresh competitive experiences.</p>

<p><strong>Global Reach:</strong> Mobile gaming transcends geographical and economic boundaries, creating truly global competitive communities.</p>

<h3>Popular Mobile Competitive Games</h3>
<ul>
<li><strong>PUBG Mobile / BGMI:</strong> Battle royale with intense strategic gameplay</li>
<li><strong>Call of Duty Mobile:</strong> Fast-paced FPS action optimized for mobile</li>
<li><strong>Clash Royale:</strong> Strategic card-based battles with real-time action</li>
<li><strong>Free Fire:</strong> Quick battle royale matches perfect for mobile</li>
</ul>

<h3>The Future of Mobile Esports</h3>
<p>As mobile hardware continues to improve and 5G networks become widespread, mobile gaming will only become more competitive and engaging. We expect to see:</p>
<ul>
<li>More console-quality games on mobile platforms</li>
<li>Increased prize pools for mobile tournaments</li>
<li>Better streaming and spectator experiences</li>
<li>Cross-platform play between mobile and other devices</li>
</ul>

<p>At BattleMania, we\'re committed to supporting the mobile gaming revolution by providing fair, competitive platforms for mobile gamers to showcase their skills and earn rewards.</p>
                ',
                'excerpt' => 'Explore how mobile gaming has transformed into a serious competitive esports platform with global reach.',
                'type' => Post::TYPE_BLOG,
            ]
        ];

        foreach ($posts as $postData) {
            Post::create([
                'title' => $postData['title'],
                'slug' => \Illuminate\Support\Str::slug($postData['title']),
                'content' => $postData['content'],
                'excerpt' => $postData['excerpt'],
                'type' => $postData['type'],
                'status' => Post::STATUS_PUBLISHED,
                'author_id' => $admin->id,
                'published_at' => now(),
                'views' => rand(100, 1000),
                'pending_approval' => false,
            ]);
        }
    }
}
