<?php

namespace Database\Seeders;

use App\Models\Post;
use App\Models\PopupNotification;
use App\Models\User;
use Illuminate\Database\Seeder;

class ContentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Get admin user
        $admin = User::where('email', 'admin@battlemania.com')->first();
        if (!$admin) {
            return;
        }

        // Create sample blog posts
        $posts = [
            [
                'title' => 'Welcome to BattleMania Gaming Platform',
                'slug' => 'welcome-to-battlemania-gaming-platform',
                'content' => "Welcome to BattleMania, the ultimate destination for competitive mobile gaming! We're excited to have you join our growing community of elite gamers.\n\nOur platform offers:\n\n• 1v1 Challenge System with real money wagering\n• Tournament hosting and participation\n• Comprehensive leaderboards and ranking system\n• Secure wallet system for deposits and withdrawals\n• Level progression and achievement badges\n\nWhether you're a CODM veteran, PUBG Mobile strategist, or FIFA Mobile champion, BattleMania provides the competitive environment you need to showcase your skills and earn rewards.\n\nGet started today by creating your first challenge or joining an upcoming tournament. Good luck, and may the best gamer win!",
                'excerpt' => 'Discover the ultimate competitive gaming platform for mobile esports enthusiasts.',
                'type' => 'blog',
                'status' => 'published',
                'published_at' => now()->subDays(5),
                'metadata' => [
                    'game_title' => 'Multiple Games',
                    'participants' => 'All Levels'
                ]
            ],
            [
                'title' => 'CODM Championship Tournament - $5000 Prize Pool',
                'slug' => 'codm-championship-tournament-5000-prize-pool',
                'content' => "🏆 MEGA TOURNAMENT ANNOUNCEMENT 🏆\n\nWe're thrilled to announce our biggest tournament yet - the BattleMania CODM Championship with a massive $5,000 prize pool!\n\n📅 Tournament Details:\n• Start Date: January 15th, 2025\n• Registration Deadline: January 10th, 2025\n• Format: 64-player bracket elimination\n• Entry Fee: $50 per player\n• Game Mode: Battle Royale (Blackout)\n\n💰 Prize Distribution:\n• 1st Place: $2,500\n• 2nd Place: $1,500\n• 3rd Place: $750\n• 4th Place: $250\n\n📋 Requirements:\n• Minimum Level 3 account\n• Valid KYC verification\n• Tournament entry fee deposit\n• Discord for communication\n\nRegistration opens Monday, January 6th at 12:00 PM EST. Spots are limited and will fill up fast!\n\nPrepare your loadouts, practice your strategies, and get ready for the most competitive CODM tournament BattleMania has ever hosted!",
                'excerpt' => 'Join our biggest CODM tournament yet with $5,000 in prizes up for grabs!',
                'type' => 'tournament',
                'status' => 'published',
                'published_at' => now()->subDays(3),
                'metadata' => [
                    'tournament_date' => 'January 15, 2025',
                    'prize_pool' => '$5,000',
                    'game_title' => 'Call of Duty Mobile',
                    'participants' => '64 Players'
                ]
            ],
            [
                'title' => 'Weekly Highlight: Epic 1v1 PUBG Showdown',
                'slug' => 'weekly-highlight-epic-1v1-pubg-showdown',
                'content' => "This week's highlight features an absolutely incredible 1v1 showdown between two of our top-ranked PUBG Mobile players!\n\n🎮 The Match:\nGamerPro2024 vs SnipeKing faced off in a best-of-3 Sanhok match with a $500 wager on the line. What followed was one of the most intense matches we've ever witnessed on the platform.\n\n🔥 Match Highlights:\n• Round 1: SnipeKing dominated early game with superior positioning, winning with 8 kills\n• Round 2: GamerPro2024 came back strong with aggressive rushes, evening the score\n• Round 3: An epic 15-minute standoff ending in a final circle clutch by GamerPro2024\n\n📊 Final Stats:\n• Total Kills: GamerPro2024 (19) vs SnipeKing (17)\n• Damage Dealt: 2,847 vs 2,621\n• Survival Time: Nearly matched at 28+ minutes each\n\nBoth players demonstrated exceptional skill, strategy, and sportsmanship throughout the match. Congratulations to GamerPro2024 on the victory and well played to SnipeKing!\n\nThink you have what it takes to create the next highlight reel? Start your challenge today!",
                'excerpt' => 'Watch the incredible highlights from this week\'s most epic PUBG Mobile showdown.',
                'type' => 'highlight',
                'status' => 'published',
                'published_at' => now()->subDays(1),
                'metadata' => [
                    'game_title' => 'PUBG Mobile',
                    'participants' => 'GamerPro2024 vs SnipeKing',
                    'prize_pool' => '$500'
                ]
            ],
            [
                'title' => 'Platform Update 2.1: Enhanced Security & New Features',
                'slug' => 'platform-update-21-enhanced-security-new-features',
                'content' => "We're excited to roll out Platform Update 2.1, bringing significant improvements to security, user experience, and new features based on your feedback!\n\n🔒 Security Enhancements:\n• Two-factor authentication (2FA) for all accounts\n• Enhanced wallet security with additional verification steps\n• Improved fraud detection and prevention systems\n• Regular security audits and vulnerability assessments\n\n✨ New Features:\n• Advanced statistics tracking for all games\n• Custom challenge creation with more game modes\n• Enhanced notification system with popup announcements\n• Improved mobile responsiveness across all pages\n• Better search and filtering options\n\n🐛 Bug Fixes:\n• Fixed wallet transaction display issues\n• Resolved tournament bracket generation problems\n• Improved challenge acceptance notifications\n• Fixed profile picture upload functionality\n\n📱 Mobile App Updates:\n• Faster loading times\n• Improved offline functionality\n• Better push notification management\n• Enhanced chat system\n\nThese updates are now live for all users. If you experience any issues or have feedback, please don't hesitate to contact our support team.\n\nThank you for making BattleMania the premier destination for competitive mobile gaming!",
                'excerpt' => 'Discover the latest platform improvements including enhanced security and exciting new features.',
                'type' => 'update',
                'status' => 'published',
                'published_at' => now()->subHours(6),
            ],
            [
                'title' => 'Breaking: New Partnership with Mobile Gaming League',
                'slug' => 'breaking-new-partnership-mobile-gaming-league',
                'content' => "🎉 HUGE NEWS ALERT! 🎉\n\nWe're thrilled to announce our strategic partnership with the Mobile Gaming League (MGL), one of the world's premier mobile esports organizations!\n\n🤝 What This Means for You:\n• Access to MGL's exclusive tournament circuits\n• Qualification pathways to international competitions\n• Professional coaching and training resources\n• Enhanced prize pools for major tournaments\n• Direct scouting opportunities for professional teams\n\n🏆 Upcoming Collaborative Events:\n• MGL x BattleMania Championship Series\n• Monthly qualification tournaments\n• Professional player exhibition matches\n• Community challenges with pro players\n\n📈 Platform Growth:\nThis partnership represents a major milestone in our journey to become the leading competitive gaming platform. With MGL's expertise and our innovative technology, we're creating unprecedented opportunities for mobile gamers worldwide.\n\n🎮 What's Next:\n• Registration for MGL qualification tournaments opens next week\n• New tournament formats and prize structures\n• Enhanced streaming and broadcast capabilities\n• Professional player mentorship programs\n\nStay tuned for more details about qualification requirements and upcoming tournaments. This is just the beginning of an exciting new chapter for BattleMania!",
                'excerpt' => 'Major partnership announcement that will revolutionize competitive mobile gaming opportunities.',
                'type' => 'news',
                'status' => 'published',
                'published_at' => now()->subHours(2),
                'metadata' => [
                    'participants' => 'All Players',
                    'game_title' => 'Multiple Games'
                ]
            ]
        ];

        foreach ($posts as $postData) {
            Post::create(array_merge($postData, [
                'author_id' => $admin->id,
                'views' => rand(50, 500)
            ]));
        }

        // Create sample popup notifications
        $popupNotifications = [
            [
                'title' => 'Welcome to BattleMania!',
                'message' => 'Thanks for joining our gaming community! Complete your profile and start your first challenge to earn bonus XP.',
                'type' => 'success',
                'is_active' => true,
                'target_users' => ['min_level' => 1],
                'created_by' => $admin->id,
            ],
            [
                'title' => 'CODM Tournament Registration Open',
                'message' => 'The $5,000 CODM Championship tournament registration is now open! Limited spots available - register now to secure your place.',
                'type' => 'announcement',
                'is_active' => true,
                'target_users' => ['min_level' => 3],
                'start_date' => now(),
                'end_date' => now()->addDays(14),
                'created_by' => $admin->id,
            ],
            [
                'title' => 'Platform Maintenance Notice',
                'message' => 'Scheduled maintenance will occur tonight from 2:00-4:00 AM EST. During this time, some features may be temporarily unavailable.',
                'type' => 'warning',
                'is_active' => true,
                'start_date' => now()->addHours(6),
                'end_date' => now()->addHours(8),
                'created_by' => $admin->id,
            ],
            [
                'title' => 'New Partnership Announcement',
                'message' => 'We\'ve partnered with Mobile Gaming League! This means bigger tournaments, better prizes, and professional opportunities for our players.',
                'type' => 'info',
                'is_active' => true,
                'created_by' => $admin->id,
            ]
        ];

        foreach ($popupNotifications as $notificationData) {
            PopupNotification::create($notificationData);
        }

        $this->command->info('Sample content created successfully!');
    }
}
