<?php

namespace Database\Seeders;

use App\Models\Level;
use App\Models\Badge;
use App\Models\Game;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // Seed platform settings first
        $this->call(PlatformSettingsSeeder::class);
        
        // Create the 30-level system with proper progression and Creator level
        $this->call(ThirtyLevelSystemSeeder::class);

        // Create games if they don't exist
        $games = [
            ['name' => 'Call of Duty Mobile', 'slug' => 'cod-mobile', 'platform' => 'mobile'],
            ['name' => 'PUBG Mobile', 'slug' => 'pubg-mobile', 'platform' => 'mobile'],
            ['name' => 'FIFA Mobile', 'slug' => 'fifa-mobile', 'platform' => 'mobile'],
            ['name' => 'Free Fire', 'slug' => 'free-fire', 'platform' => 'mobile'],
            ['name' => 'Fortnite', 'slug' => 'fortnite', 'platform' => 'pc'],
            ['name' => 'Valorant', 'slug' => 'valorant', 'platform' => 'pc'],
            ['name' => 'League of Legends', 'slug' => 'lol', 'platform' => 'pc'],
            ['name' => 'FIFA 24', 'slug' => 'fifa-24', 'platform' => 'console'],
        ];

        foreach ($games as $gameData) {
            Game::firstOrCreate(['slug' => $gameData['slug']], $gameData);
        }

        // Create badges if they don't exist
        $badges = [
            ['name' => 'First Victory', 'description' => 'Won your first challenge', 'icon' => '🏆'],
            ['name' => 'Rising Champion', 'description' => 'Won 10 challenges', 'icon' => '⭐'],
            ['name' => 'Veteran Fighter', 'description' => 'Won 50 challenges', 'icon' => '💪'],
            ['name' => 'Gaming Legend', 'description' => 'Won 100 challenges', 'icon' => '👑'],
            ['name' => 'Tournament Rookie', 'description' => 'Participated in your first tournament', 'icon' => '🎯'],
            ['name' => 'Tournament Regular', 'description' => 'Participated in 10 tournaments', 'icon' => '🎮'],
            ['name' => 'Tournament Master', 'description' => 'Participated in 25 tournaments', 'icon' => '🏅'],
            ['name' => 'First Match', 'description' => 'Played your first match', 'icon' => '🎲'],
            ['name' => 'Active Player', 'description' => 'Played 25 matches', 'icon' => '⚡'],
            ['name' => 'Gaming Addict', 'description' => 'Played 100 matches', 'icon' => '🔥'],
            ['name' => 'Perfect Streak', 'description' => 'Won 10 matches in a row without disputes', 'icon' => '💯'],
            ['name' => 'High Roller', 'description' => 'Participated in 5 high-stakes challenges', 'icon' => '💰'],
            ['name' => 'Verified Player', 'description' => 'Completed KYC verification', 'icon' => '✅'],
        ];

        foreach ($badges as $badgeData) {
            Badge::firstOrCreate(['name' => $badgeData['name']], $badgeData);
        }

        // Create admin user
        // Determine admin password: use env or generate random
        $adminPassword = env('ADMIN_PASSWORD');
        if (!$adminPassword) {
            $adminPassword = 'password';
            if (isset($this->command)) {
                $this->command->info("Admin user password (default): password");
            } else {
                echo "Admin user password (default): password\n";
            }
        }
        
        User::create([
            'username' => 'admin',
            'email' => 'admin@battlemania.com',
            'password' => Hash::make($adminPassword),
            'xp' => 1000,
            'level' => 5,
            'wallet_balance' => 10000,
            'kyc_status' => 'verified',
            'is_organizer' => true,
            'role' => 'admin',
            'status' => 'active',
        ]);

        // Create demo users with new role system
        User::create([
            'username' => 'gamer1',
            'email' => 'gamer1@example.com',
            'password' => Hash::make('password'),
            'xp' => 150,
            'level' => 2,
            'wallet_balance' => 5000,
            'role' => 'basic_user',
            'status' => 'active',
        ]);

        User::create([
            'username' => 'player2',
            'email' => 'player2@example.com',
            'password' => Hash::make('password'),
            'xp' => 300,
            'level' => 3,
            'wallet_balance' => 7500,
            'role' => 'basic_user',
            'status' => 'active',
        ]);

        // Create a premium user
        User::create([
            'username' => 'premiumuser',
            'email' => 'premium@example.com',
            'password' => Hash::make('password'),
            'xp' => 2900,
            'level' => 29,
            'wallet_balance' => 50000,
            'role' => 'premium_user',
            'status' => 'active',
        ]);

        // Create a moderator
        User::create([
            'username' => 'moderator1',
            'email' => 'moderator@example.com',
            'password' => Hash::make('password'),
            'xp' => 1500,
            'level' => 15,
            'wallet_balance' => 25000,
            'role' => 'moderator',
            'status' => 'active',
        ]);

        // Create a creator
        $creatorLevel = Level::where('name', 'Creator')->first();
        User::create([
            'username' => 'creator1',
            'email' => 'creator@example.com',
            'password' => Hash::make('password'),
            'xp' => 3000,
            'level' => $creatorLevel ? $creatorLevel->id : 31,
            'wallet_balance' => 100000,
            'role' => 'creator',
            'status' => 'active',
        ]);
    }
}