<?php

namespace Database\Seeders;

use App\Models\NotificationSetting;
use Illuminate\Database\Seeder;

class NotificationSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Create default notification settings
        $settings = [
            [
                'key' => 'email_enabled',
                'value' => '1',
                'description' => 'Enable email notifications',
                'type' => 'boolean',
            ],
            [
                'key' => 'sms_enabled',
                'value' => '1',
                'description' => 'Enable SMS notifications',
                'type' => 'boolean',
            ],
            [
                'key' => 'default_email_from',
                'value' => 'noreply@battlemania.com',
                'description' => 'Default email from address',
                'type' => 'string',
            ],
            [
                'key' => 'test_email',
                'value' => 'admin@battlemania.com',
                'description' => 'Test email address for provider testing',
                'type' => 'string',
            ],
            [
                'key' => 'test_phone',
                'value' => '+1234567890',
                'description' => 'Test phone number for provider testing',
                'type' => 'string',
            ],
        ];

        foreach ($settings as $setting) {
            NotificationSetting::updateOrCreate(
                ['key' => $setting['key']],
                $setting
            );
        }
    }
}
