<?php

namespace Database\Seeders;

use App\Models\PlatformSetting;
use Illuminate\Database\Seeder;

class PlatformSettingsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // General Settings
        PlatformSetting::set('platform_name', 'BattleMania', 'string', false, 'general', 'Platform name displayed across the site');
        PlatformSetting::set('platform_description', 'The ultimate gaming challenge platform for competitive players', 'string', false, 'general', 'Brief description of the platform');
        PlatformSetting::set('platform_logo', '', 'string', false, 'general', 'Platform logo URL or path');
        PlatformSetting::set('support_email', 'support@battlemania.com', 'string', false, 'general', 'Support email address');
        PlatformSetting::set('contact_phone', '+1-555-0123', 'string', false, 'general', 'Contact phone number');
        PlatformSetting::set('timezone', 'UTC', 'string', false, 'general', 'Default timezone for the platform');
        PlatformSetting::set('currency', '₦', 'string', false, 'general', 'Default currency symbol');

        // Payment Gateway Settings (empty by default - admin will configure)
        PlatformSetting::set('paystack_public_key', '', 'string', false, 'payment', 'Paystack public key');
        PlatformSetting::set('paystack_secret_key', '', 'string', true, 'payment', 'Paystack secret key');
        PlatformSetting::set('flutterwave_public_key', '', 'string', false, 'payment', 'Flutterwave public key');
        PlatformSetting::set('flutterwave_secret_key', '', 'string', true, 'payment', 'Flutterwave secret key');
        PlatformSetting::set('paypal_client_id', '', 'string', false, 'payment', 'PayPal client ID');
        PlatformSetting::set('paypal_secret', '', 'string', true, 'payment', 'PayPal secret');
        PlatformSetting::set('stripe_publishable_key', '', 'string', false, 'payment', 'Stripe publishable key');
        PlatformSetting::set('stripe_secret_key', '', 'string', true, 'payment', 'Stripe secret key');

        // Security Settings
        PlatformSetting::set('max_login_attempts', 5, 'integer', false, 'security', 'Maximum login attempts before lockout');
        PlatformSetting::set('session_lifetime', 120, 'integer', false, 'security', 'Session lifetime in minutes');
        PlatformSetting::set('two_factor_enabled', false, 'boolean', false, 'security', 'Enable two-factor authentication');
        PlatformSetting::set('ip_whitelist_enabled', false, 'boolean', false, 'security', 'Enable IP whitelisting for admin');
        PlatformSetting::set('rate_limit_per_minute', 60, 'integer', false, 'security', 'Rate limit per minute for API requests');

        // Platform Configuration
        PlatformSetting::set('commission_rate', 5.0, 'float', false, 'platform', 'Platform commission rate (percentage)');
        PlatformSetting::set('minimum_deposit', 10.00, 'float', false, 'platform', 'Minimum deposit amount');
        PlatformSetting::set('maximum_deposit', 100000.00, 'float', false, 'platform', 'Maximum deposit amount');
        PlatformSetting::set('minimum_withdrawal', 50.00, 'float', false, 'platform', 'Minimum withdrawal amount');
        PlatformSetting::set('maximum_withdrawal', 50000.00, 'float', false, 'platform', 'Maximum withdrawal amount');
        PlatformSetting::set('kyc_required_for_withdrawal', true, 'boolean', false, 'platform', 'Require KYC for withdrawals');

        // Feature Settings
        PlatformSetting::set('challenges_enabled', true, 'boolean', false, 'features', 'Enable challenge system');
        PlatformSetting::set('tournaments_enabled', true, 'boolean', false, 'features', 'Enable tournament system');
        PlatformSetting::set('wallet_enabled', true, 'boolean', false, 'features', 'Enable wallet system');
        PlatformSetting::set('referral_enabled', false, 'boolean', false, 'features', 'Enable referral system');
        PlatformSetting::set('level_system_enabled', true, 'boolean', false, 'features', 'Enable level progression system');
    }
}
