import './bootstrap';
import Alpine from 'alpinejs';
import AOS from 'aos';
import 'aos/dist/aos.css';

// Make Alpine available globally
window.Alpine = Alpine;

// Alpine.js setup for interactive components
Alpine.data('xpProgress', () => ({
    currentXp: 0,
    targetXp: 0,
    progress: 0,
    
    init() {
        this.currentXp = parseInt(this.$el.dataset.currentXp) || 0;
        this.targetXp = parseInt(this.$el.dataset.targetXp) || 100;
        this.updateProgress();
    },
    
    updateProgress() {
        this.progress = Math.min((this.currentXp / this.targetXp) * 100, 100);
    }
}));

Alpine.data('walletBalance', () => ({
    balance: 0,
    animatedBalance: 0,
    
    init() {
        this.balance = parseFloat(this.$el.dataset.balance) || 0;
        this.animateBalance();
    },
    
    animateBalance() {
        const start = this.animatedBalance;
        const end = this.balance;
        const duration = 1000;
        const startTime = Date.now();
        
        const animate = () => {
            const elapsed = Date.now() - startTime;
            const progress = Math.min(elapsed / duration, 1);
            
            this.animatedBalance = start + (end - start) * progress;
            
            if (progress < 1) {
                requestAnimationFrame(animate);
            }
        };
        
        animate();
    }
}));

Alpine.data('challengeTimer', () => ({
    timeLeft: 0,
    timeString: '',
    
    init() {
        this.timeLeft = parseInt(this.$el.dataset.timeLeft) || 0;
        this.updateTimeString();
        this.startTimer();
    },
    
    startTimer() {
        const timer = setInterval(() => {
            if (this.timeLeft <= 0) {
                clearInterval(timer);
                return;
            }
            
            this.timeLeft--;
            this.updateTimeString();
        }, 1000);
    },
    
    updateTimeString() {
        const hours = Math.floor(this.timeLeft / 3600);
        const minutes = Math.floor((this.timeLeft % 3600) / 60);
        const seconds = this.timeLeft % 60;
        
        if (hours > 0) {
            this.timeString = `${hours}h ${minutes}m ${seconds}s`;
        } else if (minutes > 0) {
            this.timeString = `${minutes}m ${seconds}s`;
        } else {
            this.timeString = `${seconds}s`;
        }
    }
}));

// Gaming UI enhancements
Alpine.data('gamingUI', () => ({
    init() {
        // Add gaming sound effects (optional)
        this.addHoverEffects();
    },
    
    addHoverEffects() {
        // Add subtle animations to gaming elements
        document.querySelectorAll('.btn-gaming, .btn-gaming-outline').forEach(btn => {
            btn.addEventListener('mouseenter', () => {
                btn.style.transform = 'translateY(-2px)';
            });
            
            btn.addEventListener('mouseleave', () => {
                btn.style.transform = 'translateY(0)';
            });
        });
    }
}));

// Start Alpine
Alpine.start();

// Initialize AOS
AOS.init({
    duration: 800,
    easing: 'ease-in-out',
    once: true,
    offset: 100
});