@extends('layouts.app')

@section('title', 'Create Challenge')

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="mb-8">
            <div class="flex items-center space-x-4 mb-4">
                <a href="{{ route('admin.challenges.index') }}" class="btn-secondary px-4 py-2">
                    ← Back to Challenges
                </a>
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Create Challenge</h1>
            </div>
            <p class="text-gray-400">Create a new challenge between players</p>
        </div>

        <div class="gaming-card rounded-lg p-8">
            <form action="{{ route('admin.challenges.store') }}" method="POST" class="space-y-6">
                @csrf

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="creator_id" class="block text-sm font-medium text-cod-green mb-2">Challenge Creator</label>
                        <select id="creator_id" 
                                name="creator_id" 
                                class="gaming-select w-full @error('creator_id') border-red-500 @enderror"
                                required>
                            <option value="">Select Creator</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('creator_id') == $user->id ? 'selected' : '' }}>
                                    {{ $user->username }} (₦{{ number_format($user->wallet_balance, 2) }})
                                </option>
                            @endforeach
                        </select>
                        @error('creator_id')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="accepter_id" class="block text-sm font-medium text-cod-green mb-2">Challenge Accepter (Optional)</label>
                        <select id="accepter_id" 
                                name="accepter_id" 
                                class="gaming-select w-full @error('accepter_id') border-red-500 @enderror">
                            <option value="">Leave open for anyone</option>
                            @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('accepter_id') == $user->id ? 'selected' : '' }}>
                                    {{ $user->username }} (₦{{ number_format($user->wallet_balance, 2) }})
                                </option>
                            @endforeach
                        </select>
                        @error('accepter_id')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="game_id" class="block text-sm font-medium text-cod-green mb-2">Game</label>
                        <select id="game_id" 
                                name="game_id" 
                                class="gaming-select w-full @error('game_id') border-red-500 @enderror"
                                required>
                            <option value="">Select Game</option>
                            @foreach($games as $game)
                                <option value="{{ $game->id }}" {{ old('game_id') == $game->id ? 'selected' : '' }}>
                                    {{ $game->name }} ({{ $game->platform }})
                                </option>
                            @endforeach
                        </select>
                        @error('game_id')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="wager_amount" class="block text-sm font-medium text-cod-green mb-2">Wager Amount (₦)</label>
                        <input type="number" 
                               id="wager_amount" 
                               name="wager_amount" 
                               value="{{ old('wager_amount') }}"
                               min="0.01"
                               step="0.01"
                               class="gaming-input w-full @error('wager_amount') border-red-500 @enderror"
                               placeholder="100.00"
                               required>
                        @error('wager_amount')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div>
                    <label for="best_of" class="block text-sm font-medium text-cod-green mb-2">Best Of</label>
                    <select id="best_of" 
                            name="best_of" 
                            class="gaming-select w-full @error('best_of') border-red-500 @enderror"
                            required>
                        <option value="">Select Format</option>
                        <option value="1" {{ old('best_of') == '1' ? 'selected' : '' }}>Best of 1</option>
                        <option value="3" {{ old('best_of') == '3' ? 'selected' : '' }}>Best of 3</option>
                        <option value="5" {{ old('best_of') == '5' ? 'selected' : '' }}>Best of 5</option>
                        <option value="7" {{ old('best_of') == '7' ? 'selected' : '' }}>Best of 7</option>
                    </select>
                    @error('best_of')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="rules_text" class="block text-sm font-medium text-cod-green mb-2">Challenge Rules</label>
                    <textarea id="rules_text" 
                              name="rules_text" 
                              rows="6"
                              class="gaming-textarea w-full @error('rules_text') border-red-500 @enderror"
                              placeholder="Describe the rules and requirements for this challenge..."
                              required>{{ old('rules_text') }}</textarea>
                    @error('rules_text')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="bg-cod-gray rounded-lg p-4 border border-cod-green/20">
                    <h3 class="text-lg font-medium text-cod-green mb-3">💡 Challenge Creation Notes</h3>
                    <div class="text-sm text-gray-300 space-y-2">
                        <div>• <strong>Creator Balance:</strong> The wager amount will be deducted from the creator's wallet immediately</div>
                        <div>• <strong>Auto-Accept:</strong> If you select an accepter, the challenge will be automatically accepted and their wager deducted</div>
                        <div>• <strong>Open Challenge:</strong> Leave accepter empty to create an open challenge for anyone to accept</div>
                        <div>• <strong>Platform Fee:</strong> 5% platform fee will be deducted from the prize pool when challenge is completed</div>
                    </div>
                </div>

                <div class="flex justify-end space-x-4 pt-6">
                    <a href="{{ route('admin.challenges.index') }}" class="btn-secondary px-6 py-3">
                        Cancel
                    </a>
                    <button type="submit" class="gaming-button px-6 py-3 rounded-lg">
                        Create Challenge
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection