@extends('layouts.app')

@section('title', 'Challenge Details')

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.challenges.index') }}" class="btn-secondary px-4 py-2">
                        ← Back to Challenges
                    </a>
                    <div>
                        <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Challenge #{{ $challenge->id }}</h1>
                        <p class="text-gray-400">Challenge details and management</p>
                    </div>
                </div>
                
                <div class="flex space-x-3">
                    @if($challenge->status == 'accepted' || $challenge->status == 'disputed')
                        <button onclick="showResolveModal()" class="gaming-button px-4 py-2 rounded-lg">
                            Resolve Challenge
                        </button>
                    @endif
                    @if($challenge->status != 'completed' && $challenge->status != 'cancelled')
                        <form action="{{ route('admin.challenges.cancel', $challenge) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="btn-danger px-4 py-2" 
                                    onclick="return confirm('Are you sure you want to cancel this challenge?')">
                                Cancel Challenge
                            </button>
                        </form>
                    @endif
                </div>
            </div>
        </div>

        <!-- Challenge Overview -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
            <div class="lg:col-span-2 gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Challenge Information</h3>
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <span class="text-gray-400 text-sm">Game:</span>
                            <div class="text-white font-medium">{{ $challenge->game->name }}</div>
                        </div>
                        <div>
                            <span class="text-gray-400 text-sm">Platform:</span>
                            <div class="text-white font-medium">{{ $challenge->game->platform }}</div>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <span class="text-gray-400 text-sm">Format:</span>
                            <div class="text-white font-medium">Best of {{ $challenge->best_of }}</div>
                        </div>
                        <div>
                            <span class="text-gray-400 text-sm">Wager per Player:</span>
                            <div class="text-white font-medium">₦{{ number_format($challenge->wager_amount, 2) }}</div>
                        </div>
                    </div>

                    <div>
                        <span class="text-gray-400 text-sm">Rules:</span>
                        <div class="text-white mt-1 p-3 bg-cod-gray rounded-lg">{{ $challenge->rules_text }}</div>
                    </div>

                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <span class="text-gray-400 text-sm">Total Prize Pool:</span>
                            <div class="text-white font-medium">₦{{ number_format($challenge->getTotalEscrowAmount(), 2) }}</div>
                        </div>
                        <div>
                            <span class="text-gray-400 text-sm">Winner Prize (after 5% fee):</span>
                            <div class="text-white font-medium">₦{{ number_format($challenge->getTotalEscrowAmount() * 0.95, 2) }}</div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Challenge Status</h3>
                <div class="space-y-4">
                    <div class="text-center">
                        <span class="status-badge status-{{ $challenge->status }} text-lg px-4 py-2">
                            {{ ucfirst($challenge->status) }}
                        </span>
                    </div>
                    
                    @if($challenge->result)
                        <div class="text-center">
                            <div class="text-sm text-gray-400">Result</div>
                            <div class="text-cod-green font-medium">
                                @if($challenge->result === 'creator_win')
                                    {{ $challenge->creator->username }} Wins
                                @elseif($challenge->result === 'accepter_win')
                                    {{ $challenge->accepter->username }} Wins
                                @else
                                    Draw
                                @endif
                            </div>
                        </div>
                    @endif
                    
                    <div class="text-center">
                        <div class="text-sm text-gray-400">Created</div>
                        <div class="text-white font-medium">{{ $challenge->created_at->format('M j, Y g:i A') }}</div>
                    </div>

                    <div class="text-center">
                        <div class="text-sm text-gray-400">Updated</div>
                        <div class="text-white font-medium">{{ $challenge->updated_at->diffForHumans() }}</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Players -->
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8 mb-8">
            <!-- Creator -->
            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Challenge Creator</h3>
                <div class="flex items-center space-x-4 mb-4">
                    <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center">
                        <span class="text-xl font-bold text-black">{{ substr($challenge->creator->username, 0, 1) }}</span>
                    </div>
                    <div>
                        <h4 class="text-xl font-bold text-white">{{ $challenge->creator->username }}</h4>
                        <p class="text-gray-400">Level {{ $challenge->creator->level }} • {{ $challenge->creator->xp }} XP</p>
                    </div>
                </div>
                <div class="space-y-2 text-sm">
                    <div class="flex justify-between">
                        <span class="text-gray-400">Email:</span>
                        <span class="text-white">{{ $challenge->creator->email }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Wallet Balance:</span>
                        <span class="text-white">₦{{ number_format($challenge->creator->wallet_balance, 2) }}</span>
                    </div>
                    <div class="flex justify-between">
                        <span class="text-gray-400">Status:</span>
                        <span class="status-badge status-{{ $challenge->creator->status }}">{{ ucfirst($challenge->creator->status) }}</span>
                    </div>
                </div>
            </div>

            <!-- Accepter -->
            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Challenge Accepter</h3>
                @if($challenge->accepter)
                    <div class="flex items-center space-x-4 mb-4">
                        <div class="w-16 h-16 bg-cod-green rounded-full flex items-center justify-center">
                            <span class="text-xl font-bold text-black">{{ substr($challenge->accepter->username, 0, 1) }}</span>
                        </div>
                        <div>
                            <h4 class="text-xl font-bold text-white">{{ $challenge->accepter->username }}</h4>
                            <p class="text-gray-400">Level {{ $challenge->accepter->level }} • {{ $challenge->accepter->xp }} XP</p>
                        </div>
                    </div>
                    <div class="space-y-2 text-sm">
                        <div class="flex justify-between">
                            <span class="text-gray-400">Email:</span>
                            <span class="text-white">{{ $challenge->accepter->email }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-400">Wallet Balance:</span>
                            <span class="text-white">₦{{ number_format($challenge->accepter->wallet_balance, 2) }}</span>
                        </div>
                        <div class="flex justify-between">
                            <span class="text-gray-400">Status:</span>
                            <span class="status-badge status-{{ $challenge->accepter->status }}">{{ ucfirst($challenge->accepter->status) }}</span>
                        </div>
                    </div>
                @else
                    <div class="text-center py-8 text-gray-400">
                        <svg class="w-12 h-12 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                        </svg>
                        <p>Open Challenge</p>
                        <p class="text-sm">Waiting for someone to accept</p>
                    </div>
                @endif
            </div>
        </div>

        <!-- Match Proofs -->
        @if($challenge->matchProofs->count() > 0)
            <div class="gaming-card rounded-lg p-6 mb-8">
                <h3 class="text-lg font-semibold text-cod-green mb-6">Match Proofs</h3>
                <div class="space-y-4">
                    @foreach($challenge->matchProofs as $proof)
                        <div class="gaming-card rounded-lg p-4">
                            <div class="flex justify-between items-start mb-2">
                                <div>
                                    <h4 class="text-white font-medium">Submitted by {{ $proof->user->username }}</h4>
                                    <p class="text-gray-400 text-sm">{{ $proof->created_at->format('M j, Y g:i A') }}</p>
                                </div>
                                <span class="status-badge status-{{ $proof->status }}">{{ ucfirst($proof->status) }}</span>
                            </div>
                            @if($proof->screenshot_url)
                                <div class="mb-2">
                                    <a href="{{ $proof->screenshot_url }}" target="_blank" class="text-cod-green hover:text-green-400">
                                        View Screenshot
                                    </a>
                                </div>
                            @endif
                            @if($proof->description)
                                <p class="text-gray-300 text-sm">{{ $proof->description }}</p>
                            @endif
                        </div>
                    @endforeach
                </div>
            </div>
        @endif

        <!-- Dispute Information -->
        @if($challenge->dispute)
            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-red-400 mb-6">⚠️ Dispute Information</h3>
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <span class="text-gray-400 text-sm">Opened by:</span>
                            <div class="text-white font-medium">{{ $challenge->dispute->openedBy->username }}</div>
                        </div>
                        <div>
                            <span class="text-gray-400 text-sm">Status:</span>
                            <span class="status-badge status-{{ $challenge->dispute->status }}">{{ ucfirst($challenge->dispute->status) }}</span>
                        </div>
                    </div>
                    <div>
                        <span class="text-gray-400 text-sm">Reason:</span>
                        <div class="text-white mt-1 p-3 bg-cod-gray rounded-lg">{{ $challenge->dispute->reason }}</div>
                    </div>
                    <div class="text-center">
                        <a href="{{ route('admin.disputes.show', $challenge->dispute) }}" class="gaming-button px-6 py-3 rounded-lg">
                            View Full Dispute Details
                        </a>
                    </div>
                </div>
            </div>
        @endif
    </div>
</div>

<!-- Resolve Challenge Modal -->
@if($challenge->status == 'accepted' || $challenge->status == 'disputed')
<div id="resolveModal" class="fixed inset-0 bg-black bg-opacity-50 hidden z-50">
    <div class="flex items-center justify-center min-h-screen p-4">
        <div class="gaming-card rounded-lg p-6 w-full max-w-md">
            <h3 class="text-lg font-semibold text-cod-green mb-4">Resolve Challenge</h3>
            <form action="{{ route('admin.challenges.resolve', $challenge) }}" method="POST" class="space-y-4">
                @csrf
                <div>
                    <label class="block text-sm font-medium text-cod-green mb-2">Select Winner</label>
                    <div class="space-y-2">
                        <label class="flex items-center">
                            <input type="radio" name="winner" value="creator" class="mr-2">
                            <span class="text-white">{{ $challenge->creator->username }} Wins</span>
                        </label>
                        @if($challenge->accepter)
                            <label class="flex items-center">
                                <input type="radio" name="winner" value="accepter" class="mr-2">
                                <span class="text-white">{{ $challenge->accepter->username }} Wins</span>
                            </label>
                        @endif
                        <label class="flex items-center">
                            <input type="radio" name="winner" value="draw" class="mr-2">
                            <span class="text-white">Draw (Refund Both Players)</span>
                        </label>
                    </div>
                </div>
                <div class="flex justify-end space-x-3 pt-4">
                    <button type="button" onclick="hideResolveModal()" class="btn-secondary px-4 py-2">Cancel</button>
                    <button type="submit" class="gaming-button px-4 py-2 rounded-lg">Resolve Challenge</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif

<script>
function showResolveModal() {
    document.getElementById('resolveModal').classList.remove('hidden');
}

function hideResolveModal() {
    document.getElementById('resolveModal').classList.add('hidden');
}
</script>
@endsection