@extends('layouts.admin')

@section('title', 'Admin Dashboard')
@section('page-title', 'Dashboard')
@section('page-subtitle', 'System overview and key metrics')

@section('content')
<div class="p-6">
    <div class="max-w-7xl mx-auto">
        <!-- Statistics Cards -->
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
            <div class="gaming-card rounded-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                            <span class="text-xl text-black">👥</span>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-cod-green">{{ number_format($stats['total_users']) }}</h3>
                            <p class="text-gray-400">Total Users</p>
                        </div>
                    </div>
                </div>
                <div class="text-sm text-gray-400">
                    {{ $stats['active_users'] }} active • {{ $stats['banned_users'] }} banned
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                            <span class="text-xl text-black">⚔️</span>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-cod-green">{{ number_format($stats['total_challenges']) }}</h3>
                            <p class="text-gray-400">Total Challenges</p>
                        </div>
                    </div>
                </div>
                <div class="text-sm text-gray-400">
                    {{ $stats['open_challenges'] }} open • {{ $stats['disputed_challenges'] }} disputed
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                            <span class="text-xl text-black">🏆</span>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-cod-green">{{ number_format($stats['total_tournaments']) }}</h3>
                            <p class="text-gray-400">Tournaments</p>
                        </div>
                    </div>
                </div>
                <div class="text-sm text-gray-400">
                    {{ $stats['ongoing_tournaments'] }} ongoing tournaments
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <div class="flex items-center justify-between mb-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                            <span class="text-xl text-black">💰</span>
                        </div>
                        <div>
                            <h3 class="text-2xl font-bold text-cod-green">₦{{ number_format($stats['total_transactions'], 2) }}</h3>
                            <p class="text-gray-400">Total Volume</p>
                        </div>
                    </div>
                </div>
                <div class="text-sm text-gray-400">
                    {{ $stats['pending_transactions'] }} pending transactions
                </div>
            </div>
        </div>

        <!-- Quick Actions Grid -->
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8 mb-8">
            <div class="gaming-card rounded-lg p-6">
                <h2 class="text-xl font-semibold text-cod-green mb-6">🚀 Quick Actions</h2>
                <div class="grid grid-cols-2 gap-4">
                    <a href="{{ route('admin.users.index') }}" class="gaming-card rounded-lg p-4 hover:bg-cod-light transition-colors">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center mx-auto mb-3">
                                <span class="text-xl text-black">👤</span>
                            </div>
                            <h3 class="text-sm font-medium text-white">Manage Users</h3>
                            <p class="text-xs text-gray-400 mt-1">View & ban users</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.games.index') }}" class="gaming-card rounded-lg p-4 hover:bg-cod-light transition-colors">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center mx-auto mb-3">
                                <span class="text-xl text-black">🎮</span>
                            </div>
                            <h3 class="text-sm font-medium text-white">Manage Games</h3>
                            <p class="text-xs text-gray-400 mt-1">Add & edit games</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.challenges.index') }}" class="gaming-card rounded-lg p-4 hover:bg-cod-light transition-colors">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center mx-auto mb-3">
                                <span class="text-xl text-black">⚔️</span>
                            </div>
                            <h3 class="text-sm font-medium text-white">Hook Players</h3>
                            <p class="text-xs text-gray-400 mt-1">Create 1v1 matches</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.tournaments.index') }}" class="gaming-card rounded-lg p-4 hover:bg-cod-light transition-colors">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center mx-auto mb-3">
                                <span class="text-xl text-black">🏆</span>
                            </div>
                            <h3 class="text-sm font-medium text-white">Tournaments</h3>
                            <p class="text-xs text-gray-400 mt-1">Create & manage</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.posts.index') }}" class="gaming-card rounded-lg p-4 hover:bg-cod-light transition-colors">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center mx-auto mb-3">
                                <span class="text-xl text-black">📝</span>
                            </div>
                            <h3 class="text-sm font-medium text-white">Content</h3>
                            <p class="text-xs text-gray-400 mt-1">Posts & updates</p>
                        </div>
                    </a>

                    <a href="{{ route('admin.popup-notifications.index') }}" class="gaming-card rounded-lg p-4 hover:bg-cod-light transition-colors">
                        <div class="text-center">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center mx-auto mb-3">
                                <span class="text-xl text-black">🔔</span>
                            </div>
                            <h3 class="text-sm font-medium text-white">Notifications</h3>
                            <p class="text-xs text-gray-400 mt-1">Popup alerts</p>
                        </div>
                    </a>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <h2 class="text-xl font-semibold text-cod-green mb-6">⚠️ Alerts & Issues</h2>
                <div class="space-y-4">
                    @if($stats['open_disputes'] > 0)
                        <div class="gaming-card rounded-lg p-4 border border-red-500/30">
                            <div class="flex items-center justify-between">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-red-500 rounded-lg flex items-center justify-center">
                                        <span class="text-white text-sm">⚠️</span>
                                    </div>
                                    <div>
                                        <h3 class="text-white font-medium">{{ $stats['open_disputes'] }} Open Disputes</h3>
                                        <p class="text-red-400 text-sm">Requires immediate attention</p>
                                    </div>
                                </div>
                                <a href="{{ route('admin.disputes.index') }}" class="btn-danger px-3 py-1 text-xs">
                                    Resolve
                                </a>
                            </div>
                        </div>
                    @endif

                    <div class="gaming-card rounded-lg p-4">
                        <div class="flex items-center justify-between">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-cod-green rounded-lg flex items-center justify-center">
                                    <span class="text-black text-sm">📊</span>
                                </div>
                                <div>
                                    <h3 class="text-white font-medium">Platform Statistics</h3>
                                    <p class="text-gray-400 text-sm">All systems operational</p>
                                </div>
                            </div>
                            <div class="text-cod-green text-sm">✓ Online</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Recent Activity -->
        <div class="gaming-card rounded-lg p-6">
            <h2 class="text-xl font-semibold text-cod-green mb-6">📈 Recent Activity</h2>
            <div class="space-y-4">
                @if(isset($recent_challenges) && $recent_challenges->count() > 0)
                    @foreach($recent_challenges->take(5) as $challenge)
                        <div class="flex items-center justify-between p-3 bg-cod-gray rounded-lg">
                            <div class="flex items-center space-x-3">
                                <div class="w-8 h-8 bg-cod-green rounded-full flex items-center justify-center">
                                    <span class="text-xs font-bold text-black">C</span>
                                </div>
                                <div>
                                    <p class="text-white text-sm">
                                        <span class="font-medium">{{ $challenge->creator->username }}</span>
                                        @if($challenge->accepter)
                                            vs <span class="font-medium">{{ $challenge->accepter->username }}</span>
                                        @else
                                            created an open challenge
                                        @endif
                                    </p>
                                    <p class="text-gray-400 text-xs">{{ $challenge->game->name }} • ₦{{ number_format($challenge->wager_amount, 2) }}</p>
                                </div>
                            </div>
                            <div class="text-right">
                                <span class="status-badge status-{{ $challenge->status }}">{{ ucfirst($challenge->status) }}</span>
                                <p class="text-gray-400 text-xs mt-1">{{ $challenge->created_at->diffForHumans() }}</p>
                            </div>
                        </div>
                    @endforeach
                @else
                    <div class="text-center py-8 text-gray-400">
                        <p>No recent activity to display</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>
@endsection