@extends('layouts.app')

@section('title', 'Add New Game')

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="mb-8">
            <div class="flex items-center space-x-4 mb-4">
                <a href="{{ route('admin.games.index') }}" class="btn-secondary px-4 py-2">
                    ← Back to Games
                </a>
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Add New Game</h1>
            </div>
            <p class="text-gray-400">Add a new game to the platform</p>
        </div>

        <div class="gaming-card rounded-lg p-8">
            <form action="{{ route('admin.games.store') }}" method="POST" class="space-y-6">
                @csrf

                <div>
                    <label for="name" class="block text-sm font-medium text-cod-green mb-2">Game Name</label>
                    <input type="text" 
                           id="name" 
                           name="name" 
                           value="{{ old('name') }}"
                           class="gaming-input w-full @error('name') border-red-500 @enderror"
                           placeholder="e.g., Call of Duty Mobile"
                           required>
                    @error('name')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div>
                    <label for="platform" class="block text-sm font-medium text-cod-green mb-2">Platform</label>
                    <select id="platform" 
                            name="platform" 
                            class="gaming-select w-full @error('platform') border-red-500 @enderror"
                            required>
                        <option value="">Select Platform</option>
                        <option value="Mobile" {{ old('platform') == 'Mobile' ? 'selected' : '' }}>Mobile</option>
                        <option value="PC" {{ old('platform') == 'PC' ? 'selected' : '' }}>PC</option>
                        <option value="Console" {{ old('platform') == 'Console' ? 'selected' : '' }}>Console</option>
                        <option value="Cross-Platform" {{ old('platform') == 'Cross-Platform' ? 'selected' : '' }}>Cross-Platform</option>
                    </select>
                    @error('platform')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="bg-cod-gray rounded-lg p-4 border border-cod-green/20">
                    <h3 class="text-lg font-medium text-cod-green mb-3">💡 Popular Games</h3>
                    <div class="grid grid-cols-2 md:grid-cols-3 gap-2 text-sm text-gray-300">
                        <div>• Call of Duty Mobile</div>
                        <div>• PUBG Mobile</div>
                        <div>• FIFA Mobile</div>
                        <div>• Free Fire</div>
                        <div>• Fortnite</div>
                        <div>• Valorant</div>
                        <div>• League of Legends</div>
                        <div>• FIFA 24</div>
                        <div>• Apex Legends</div>
                    </div>
                </div>

                <div class="flex justify-end space-x-4 pt-6">
                    <a href="{{ route('admin.games.index') }}" class="btn-secondary px-6 py-3">
                        Cancel
                    </a>
                    <button type="submit" class="gaming-button px-6 py-3 rounded-lg">
                        Add Game
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection