@extends('layouts.admin')

@section('title', 'Games Management')
@section('page-title', 'Games Management')
@section('page-subtitle', 'Manage available games on the platform')

@section('content')
<div class="p-6">
    <div class="max-w-7xl mx-auto">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Games Management</h1>
                <p class="text-gray-400 mt-2">Manage available games on the platform</p>
            </div>
            <a href="{{ route('admin.games.create') }}" class="gaming-button px-6 py-3 rounded-lg">
                Add New Game
            </a>
        </div>

        <div class="gaming-card rounded-lg p-6">
            <div class="overflow-x-auto">
                <table class="gaming-table w-full">
                    <thead>
                        <tr>
                            <th class="text-left">Game Name</th>
                            <th class="text-left">Platform</th>
                            <th class="text-center">Challenges</th>
                            <th class="text-center">Tournaments</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($games as $game)
                            <tr>
                                <td>
                                    <div class="flex items-center space-x-3">
                                        <div class="w-10 h-10 bg-cod-green rounded-lg flex items-center justify-center">
                                            <span class="text-sm font-bold text-black">{{ substr($game->name, 0, 2) }}</span>
                                        </div>
                                        <div>
                                            <div class="font-medium text-white">{{ $game->name }}</div>
                                            <div class="text-sm text-gray-400">{{ $game->slug }}</div>
                                        </div>
                                    </div>
                                </td>
                                <td>
                                    <span class="status-badge bg-cod-gray text-gray-300">{{ $game->platform }}</span>
                                </td>
                                <td class="text-center">
                                    <span class="text-cod-green font-medium">{{ $game->challenges_count }}</span>
                                </td>
                                <td class="text-center">
                                    <span class="text-cod-green font-medium">{{ $game->tournaments_count }}</span>
                                </td>
                                <td class="text-center">
                                    <div class="flex justify-center space-x-2">
                                        <a href="{{ route('admin.games.show', $game) }}" class="btn-secondary px-3 py-1 text-xs">
                                            View
                                        </a>
                                        <a href="{{ route('admin.games.edit', $game) }}" class="btn-secondary px-3 py-1 text-xs">
                                            Edit
                                        </a>
                                        @if($game->challenges_count == 0 && $game->tournaments_count == 0)
                                            <form action="{{ route('admin.games.destroy', $game) }}" method="POST" class="inline"
                                                  onsubmit="return confirm('Are you sure you want to delete this game?')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn-danger px-3 py-1 text-xs">Delete</button>
                                            </form>
                                        @endif
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-8">
                                    <div class="text-gray-400">
                                        <svg class="w-12 h-12 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9.75 17L9 20l-1 1h8l-1-1-.75-3M3 13h18M5 17h14a2 2 0 002-2V5a2 2 0 00-2-2H5a2 2 0 00-2 2v10a2 2 0 002 2z"></path>
                                        </svg>
                                        <p>No games found. Add your first game to get started!</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($games->hasPages())
                <div class="mt-6">
                    {{ $games->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection