@extends('layouts.app')

@section('title', $game->name . ' Details')

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.games.index') }}" class="btn-secondary px-4 py-2">
                        ← Back to Games
                    </a>
                    <div>
                        <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">{{ $game->name }}</h1>
                        <p class="text-gray-400">Game details and statistics</p>
                    </div>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('admin.games.edit', $game) }}" class="gaming-button px-4 py-2 rounded-lg">
                        Edit Game
                    </a>
                </div>
            </div>
        </div>

        <!-- Game Information -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Game Information</h3>
                <div class="space-y-3">
                    <div>
                        <span class="text-gray-400 text-sm">Platform:</span>
                        <div class="mt-1">
                            <span class="status-badge bg-cod-gray text-gray-300">{{ $game->platform }}</span>
                        </div>
                    </div>
                    <div>
                        <span class="text-gray-400 text-sm">Slug:</span>
                        <div class="text-white font-mono text-sm mt-1">{{ $game->slug }}</div>
                    </div>
                    <div>
                        <span class="text-gray-400 text-sm">Created:</span>
                        <div class="text-white text-sm mt-1">{{ $game->created_at->format('M j, Y g:i A') }}</div>
                    </div>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Statistics</h3>
                <div class="space-y-4">
                    <div class="flex justify-between items-center">
                        <span class="text-gray-400">Total Challenges</span>
                        <span class="text-cod-green text-xl font-bold">{{ $game->challenges->count() }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-400">Total Tournaments</span>
                        <span class="text-cod-green text-xl font-bold">{{ $game->tournaments->count() }}</span>
                    </div>
                    <div class="flex justify-between items-center">
                        <span class="text-gray-400">Total Players</span>
                        <span class="text-cod-green text-xl font-bold">
                            {{ $game->challenges->pluck('creator_id')->merge($game->challenges->pluck('accepter_id'))->unique()->count() }}
                        </span>
                    </div>
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Quick Actions</h3>
                <div class="space-y-3">
                    <a href="{{ route('admin.challenges.create') }}?game_id={{ $game->id }}" 
                       class="block btn-secondary text-center py-2">
                        Create Challenge
                    </a>
                    <a href="{{ route('admin.tournaments.create') }}?game_id={{ $game->id }}" 
                       class="block btn-secondary text-center py-2">
                        Create Tournament
                    </a>
                    <a href="{{ route('admin.games.edit', $game) }}" 
                       class="block btn-secondary text-center py-2">
                        Edit Game
                    </a>
                </div>
            </div>
        </div>

        <!-- Recent Challenges -->
        <div class="gaming-card rounded-lg p-6 mb-8">
            <h3 class="text-lg font-semibold text-cod-green mb-4">Recent Challenges</h3>
            <div class="overflow-x-auto">
                <table class="gaming-table w-full">
                    <thead>
                        <tr>
                            <th class="text-left">Creator</th>
                            <th class="text-left">Accepter</th>
                            <th class="text-center">Wager</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($game->challenges->take(10) as $challenge)
                            <tr>
                                <td class="text-white">{{ $challenge->creator->username }}</td>
                                <td class="text-white">{{ $challenge->accepter ? $challenge->accepter->username : 'Open' }}</td>
                                <td class="text-center text-cod-green">₦{{ number_format($challenge->wager_amount, 2) }}</td>
                                <td class="text-center">
                                    <span class="status-badge status-{{ $challenge->status }}">{{ ucfirst($challenge->status) }}</span>
                                </td>
                                <td class="text-center text-gray-400">{{ $challenge->created_at->diffForHumans() }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="5" class="text-center py-4 text-gray-400">No challenges found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>

        <!-- Recent Tournaments -->
        <div class="gaming-card rounded-lg p-6">
            <h3 class="text-lg font-semibold text-cod-green mb-4">Recent Tournaments</h3>
            <div class="overflow-x-auto">
                <table class="gaming-table w-full">
                    <thead>
                        <tr>
                            <th class="text-left">Title</th>
                            <th class="text-left">Host</th>
                            <th class="text-center">Entry Fee</th>
                            <th class="text-center">Participants</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($game->tournaments->take(10) as $tournament)
                            <tr>
                                <td class="text-white font-medium">{{ $tournament->title }}</td>
                                <td class="text-white">{{ $tournament->host->username }}</td>
                                <td class="text-center text-cod-green">₦{{ number_format($tournament->entry_fee, 2) }}</td>
                                <td class="text-center text-cod-green">{{ $tournament->participants->count() }}</td>
                                <td class="text-center">
                                    <span class="status-badge status-{{ $tournament->status }}">{{ ucfirst($tournament->status) }}</span>
                                </td>
                                <td class="text-center text-gray-400">{{ $tournament->created_at->diffForHumans() }}</td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="6" class="text-center py-4 text-gray-400">No tournaments found</td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection