@extends('layouts.app')

@section('title', 'Add Notification Provider')

@section('content')
<div class="admin-dashboard">
    <div class="container">
        <div class="dashboard-header">
            <h1>➕ Add {{ ucfirst($type) }} Provider</h1>
            <p>Configure a new {{ $type }} notification provider</p>
        </div>

        <!-- Back Button -->
        <div class="mb-3">
            <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                ← Back to Notifications
            </a>
        </div>

        @if(!$provider)
            <!-- Provider Selection -->
            <div class="notification-section">
                <h2>Select {{ ucfirst($type) }} Provider</h2>
                <div class="providers-selection">
                    @foreach($availableProviders as $name => $info)
                        <a href="{{ route('admin.notifications.providers.create', ['type' => $type, 'name' => $name]) }}" 
                           class="provider-option">
                            <h3>{{ $info['display_name'] }}</h3>
                            <p>{{ $info['description'] }}</p>
                        </a>
                    @endforeach
                </div>
            </div>
        @else
            <!-- Provider Configuration Form -->
            <div class="notification-section">
                <h2>Configure {{ $provider->display_name }}</h2>
                
                <form action="{{ route('admin.notifications.providers.store') }}" method="POST" class="provider-form">
                    @csrf
                    <input type="hidden" name="name" value="{{ $provider->name }}">
                    <input type="hidden" name="type" value="{{ $provider->type }}">

                    <div class="form-group">
                        <label for="display_name">Display Name</label>
                        <input type="text" name="display_name" id="display_name" 
                               value="{{ old('display_name', $provider->display_name) }}" 
                               class="form-control" required>
                        @error('display_name')
                            <div class="form-error">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group">
                        <label for="priority">Priority</label>
                        <select name="priority" id="priority" class="form-control" required>
                            @for($i = 1; $i <= 10; $i++)
                                <option value="{{ $i }}" {{ old('priority', 1) == $i ? 'selected' : '' }}>
                                    {{ $i }} {{ $i == 1 ? '(Highest)' : ($i == 10 ? '(Lowest)' : '') }}
                                </option>
                            @endfor
                        </select>
                        <small class="form-text">Lower numbers have higher priority for failover</small>
                        @error('priority')
                            <div class="form-error">{{ $message }}</div>
                        @enderror
                    </div>

                    <!-- Configuration Fields -->
                    <div class="configuration-section">
                        <h3>Configuration</h3>
                        @foreach($provider->getConfigurationFieldLabels() as $field => $label)
                            <div class="form-group">
                                <label for="configuration_{{ $field }}">{{ $label }}</label>
                                @if(in_array($field, ['secret', 'api_key', 'auth_token', 'api_secret']))
                                    <input type="password" name="configuration[{{ $field }}]" 
                                           id="configuration_{{ $field }}" 
                                           value="{{ old("configuration.{$field}") }}" 
                                           class="form-control" required
                                           placeholder="Enter your {{ strtolower($label) }}">
                                @else
                                    <input type="text" name="configuration[{{ $field }}]" 
                                           id="configuration_{{ $field }}" 
                                           value="{{ old("configuration.{$field}") }}" 
                                           class="form-control" required
                                           placeholder="Enter {{ strtolower($label) }}">
                                @endif
                                @error("configuration.{$field}")
                                    <div class="form-error">{{ $message }}</div>
                                @enderror
                            </div>
                        @endforeach
                    </div>

                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">💾 Save Provider</button>
                        <a href="{{ route('admin.notifications.index') }}" class="btn btn-secondary">Cancel</a>
                    </div>
                </form>

                <!-- Configuration Help -->
                <div class="configuration-help">
                    <h3>Configuration Help</h3>
                    @if($provider->name === 'resend')
                        <div class="help-content">
                            <h4>Resend Setup</h4>
                            <ol>
                                <li>Go to <a href="https://resend.com" target="_blank">resend.com</a> and create an account</li>
                                <li>Navigate to API Keys in your dashboard</li>
                                <li>Create a new API key with sending permissions</li>
                                <li>Copy the API key and paste it in the configuration above</li>
                            </ol>
                        </div>
                    @elseif($provider->name === 'mailgun')
                        <div class="help-content">
                            <h4>Mailgun Setup</h4>
                            <ol>
                                <li>Go to <a href="https://mailgun.com" target="_blank">mailgun.com</a> and create an account</li>
                                <li>Add and verify your domain</li>
                                <li>Get your domain name from the dashboard</li>
                                <li>Get your API key from Settings > API Keys</li>
                                <li>Endpoint is usually <code>api.mailgun.net</code> (or <code>api.eu.mailgun.net</code> for EU)</li>
                            </ol>
                        </div>
                    @elseif($provider->name === 'sendgrid')
                        <div class="help-content">
                            <h4>SendGrid Setup</h4>
                            <ol>
                                <li>Go to <a href="https://sendgrid.com" target="_blank">sendgrid.com</a> and create an account</li>
                                <li>Navigate to Settings > API Keys</li>
                                <li>Create a new API key with "Full Access" or "Mail Send" permissions</li>
                                <li>Copy the API key and paste it in the configuration above</li>
                            </ol>
                        </div>
                    @elseif($provider->name === 'termii')
                        <div class="help-content">
                            <h4>Termii Setup</h4>
                            <ol>
                                <li>Go to <a href="https://termii.com" target="_blank">termii.com</a> and create an account</li>
                                <li>Complete the verification process</li>
                                <li>Navigate to API section in your dashboard</li>
                                <li>Copy your API key</li>
                                <li>Register a sender ID (this is what recipients see as sender)</li>
                            </ol>
                        </div>
                    @elseif($provider->name === 'twilio')
                        <div class="help-content">
                            <h4>Twilio Setup</h4>
                            <ol>
                                <li>Go to <a href="https://twilio.com" target="_blank">twilio.com</a> and create an account</li>
                                <li>Verify your phone number</li>
                                <li>Get your Account SID and Auth Token from the console</li>
                                <li>Purchase a phone number or use your trial number</li>
                                <li>Enter the phone number in +1234567890 format</li>
                            </ol>
                        </div>
                    @elseif($provider->name === 'nexmo')
                        <div class="help-content">
                            <h4>Nexmo (Vonage) Setup</h4>
                            <ol>
                                <li>Go to <a href="https://vonage.com" target="_blank">vonage.com</a> and create an account</li>
                                <li>Navigate to API Keys in your dashboard</li>
                                <li>Copy your API Key and API Secret</li>
                                <li>Set up a virtual number for sending SMS</li>
                                <li>Enter the number in +1234567890 format</li>
                            </ol>
                        </div>
                    @endif
                </div>
            </div>
        @endif
    </div>
</div>

<style>
.providers-selection {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 1.5rem;
}

.provider-option {
    background: rgba(0, 30, 60, 0.6);
    border: 1px solid #444;
    border-radius: 8px;
    padding: 1.5rem;
    text-decoration: none;
    color: inherit;
    transition: all 0.3s ease;
    display: block;
}

.provider-option:hover {
    border-color: #007bff;
    box-shadow: 0 0 15px rgba(0, 123, 255, 0.3);
    color: inherit;
    text-decoration: none;
}

.provider-option h3 {
    color: #fff;
    margin: 0 0 0.5rem 0;
}

.provider-option p {
    color: #ccc;
    margin: 0;
}

.provider-form {
    max-width: 600px;
}

.configuration-section {
    background: rgba(0, 20, 40, 0.5);
    border: 1px solid #333;
    border-radius: 8px;
    padding: 1.5rem;
    margin: 1.5rem 0;
}

.configuration-section h3 {
    color: #fff;
    margin: 0 0 1rem 0;
}

.form-actions {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
}

.configuration-help {
    background: rgba(0, 40, 80, 0.3);
    border: 1px solid #444;
    border-radius: 8px;
    padding: 1.5rem;
    margin-top: 2rem;
}

.configuration-help h3 {
    color: #fff;
    margin: 0 0 1rem 0;
}

.help-content h4 {
    color: #17a2b8;
    margin: 1rem 0 0.5rem 0;
}

.help-content ol {
    color: #ccc;
    padding-left: 1.5rem;
}

.help-content li {
    margin-bottom: 0.5rem;
}

.help-content a {
    color: #17a2b8;
}

.help-content code {
    background: rgba(0, 0, 0, 0.3);
    padding: 0.2rem 0.4rem;
    border-radius: 3px;
    color: #e83e8c;
}

.form-error {
    color: #dc3545;
    font-size: 0.875rem;
    margin-top: 0.25rem;
}

.form-text {
    color: #6c757d;
    font-size: 0.875rem;
    margin-top: 0.25rem;
}
</style>
@endsection