@extends('layouts.app')

@section('title', 'Edit Notification Provider')

@section('content')
<div class="admin-dashboard">
    <div class="container">
        <div class="dashboard-header">
            <h1>✏️ Edit {{ $provider->display_name }}</h1>
            <p>Update {{ $provider->type }} provider configuration</p>
        </div>

        <!-- Back Button -->
        <div class="mb-3">
            <a href="{{ route('admin.notifications.index') }}" class="btn btn-outline-secondary">
                ← Back to Notifications
            </a>
        </div>

        <!-- Provider Configuration Form -->
        <div class="notification-section">
            <form action="{{ route('admin.notifications.providers.update', $provider) }}" method="POST" class="provider-form">
                @csrf
                @method('PUT')

                <div class="form-group">
                    <label for="display_name">Display Name</label>
                    <input type="text" name="display_name" id="display_name" 
                           value="{{ old('display_name', $provider->display_name) }}" 
                           class="form-control" required>
                    @error('display_name')
                        <div class="form-error">{{ $message }}</div>
                    @enderror
                </div>

                <div class="form-group">
                    <label for="priority">Priority</label>
                    <select name="priority" id="priority" class="form-control" required>
                        @for($i = 1; $i <= 10; $i++)
                            <option value="{{ $i }}" {{ old('priority', $provider->priority) == $i ? 'selected' : '' }}>
                                {{ $i }} {{ $i == 1 ? '(Highest)' : ($i == 10 ? '(Lowest)' : '') }}
                            </option>
                        @endfor
                    </select>
                    <small class="form-text">Lower numbers have higher priority for failover</small>
                    @error('priority')
                        <div class="form-error">{{ $message }}</div>
                    @enderror
                </div>

                <!-- Configuration Fields -->
                <div class="configuration-section">
                    <h3>Configuration</h3>
                    @foreach($provider->getConfigurationFieldLabels() as $field => $label)
                        <div class="form-group">
                            <label for="configuration_{{ $field }}">{{ $label }}</label>
                            @if(in_array($field, ['secret', 'api_key', 'auth_token', 'api_secret']))
                                <input type="password" name="configuration[{{ $field }}]" 
                                       id="configuration_{{ $field }}" 
                                       value="{{ old("configuration.{$field}", $provider->configuration[$field] ?? '') }}" 
                                       class="form-control" required
                                       placeholder="Enter your {{ strtolower($label) }}">
                                <small class="form-text">Leave empty to keep current value</small>
                            @else
                                <input type="text" name="configuration[{{ $field }}]" 
                                       id="configuration_{{ $field }}" 
                                       value="{{ old("configuration.{$field}", $provider->configuration[$field] ?? '') }}" 
                                       class="form-control" required
                                       placeholder="Enter {{ strtolower($label) }}">
                            @endif
                            @error("configuration.{$field}")
                                <div class="form-error">{{ $message }}</div>
                            @enderror
                        </div>
                    @endforeach
                </div>

                <!-- Current Status -->
                <div class="current-status">
                    <h3>Current Status</h3>
                    <div class="status-grid">
                        <div class="status-item">
                            <strong>Status:</strong>
                            <span class="badge {{ $provider->is_active ? 'badge-success' : 'badge-secondary' }}">
                                {{ $provider->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </div>

                        <div class="status-item">
                            <strong>Default:</strong>
                            <span class="badge {{ $provider->is_default ? 'badge-primary' : 'badge-secondary' }}">
                                {{ $provider->is_default ? 'Yes' : 'No' }}
                            </span>
                        </div>

                        @if($provider->last_tested_at)
                            <div class="status-item">
                                <strong>Last Tested:</strong>
                                <span>{{ $provider->last_tested_at->diffForHumans() }}</span>
                            </div>

                            @if($provider->test_results)
                                <div class="status-item">
                                    <strong>Test Result:</strong>
                                    <span class="test-result {{ $provider->test_results['success'] ? 'success' : 'error' }}">
                                        {{ $provider->test_results['message'] }}
                                    </span>
                                </div>
                            @endif
                        @else
                            <div class="status-item">
                                <strong>Test Status:</strong>
                                <span class="test-result warning">Not tested</span>
                            </div>
                        @endif
                    </div>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn btn-primary">💾 Update Provider</button>
                    <a href="{{ route('admin.notifications.index') }}" class="btn btn-secondary">Cancel</a>
                </div>
            </form>

            <!-- Test Provider -->
            <div class="test-section">
                <h3>Test Provider</h3>
                <p>Test this provider configuration to ensure it's working properly.</p>
                <form action="{{ route('admin.notifications.providers.test', $provider) }}" method="POST" style="display: inline;">
                    @csrf
                    <button type="submit" class="btn btn-info">🧪 Test Provider</button>
                </form>
            </div>
        </div>
    </div>
</div>

<style>
.provider-form {
    max-width: 600px;
}

.configuration-section {
    background: rgba(0, 20, 40, 0.5);
    border: 1px solid #333;
    border-radius: 8px;
    padding: 1.5rem;
    margin: 1.5rem 0;
}

.configuration-section h3 {
    color: #fff;
    margin: 0 0 1rem 0;
}

.current-status {
    background: rgba(0, 40, 80, 0.3);
    border: 1px solid #444;
    border-radius: 8px;
    padding: 1.5rem;
    margin: 1.5rem 0;
}

.current-status h3 {
    color: #fff;
    margin: 0 0 1rem 0;
}

.status-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
    gap: 1rem;
}

.status-item {
    color: #ccc;
}

.status-item strong {
    color: #fff;
}

.badge {
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 600;
}

.badge-primary { background: #007bff; color: white; }
.badge-success { background: #28a745; color: white; }
.badge-secondary { background: #6c757d; color: white; }

.test-result.success { color: #28a745; }
.test-result.error { color: #dc3545; }
.test-result.warning { color: #ffc107; }

.test-section {
    background: rgba(0, 60, 120, 0.3);
    border: 1px solid #007bff;
    border-radius: 8px;
    padding: 1.5rem;
    margin: 2rem 0;
}

.test-section h3 {
    color: #17a2b8;
    margin: 0 0 0.5rem 0;
}

.test-section p {
    color: #ccc;
    margin-bottom: 1rem;
}

.form-actions {
    display: flex;
    gap: 1rem;
    margin-top: 2rem;
}

.form-error {
    color: #dc3545;
    font-size: 0.875rem;
    margin-top: 0.25rem;
}

.form-text {
    color: #6c757d;
    font-size: 0.875rem;
    margin-top: 0.25rem;
}
</style>
@endsection