@extends('layouts.admin')

@section('title', 'API Notifications')
@section('page-title', 'API Notifications')
@section('page-subtitle', 'Manage system notifications and alerts')

@section('content')
<div class="p-6">
    <div class="max-w-7xl mx-auto">
        <div class="dashboard-header">
            <h1>📧 Notification Settings</h1>
            <p>Configure email and SMS providers for platform notifications</p>
        </div>

        <!-- Flash Messages -->
        @if(session('success'))
            <div class="alert alert-success">{{ session('success') }}</div>
        @endif
        @if(session('error'))
            <div class="alert alert-danger">{{ session('error') }}</div>
        @endif

        <!-- General Settings -->
        <div class="notification-section">
            <h2>⚙️ General Settings</h2>
            <form action="{{ route('admin.notifications.settings.update') }}" method="POST" class="settings-form">
                @csrf
                <div class="form-grid">
                    <div class="form-group">
                        <label for="email_enabled">Email Notifications</label>
                        <select name="email_enabled" id="email_enabled" class="form-control">
                            <option value="1" {{ $settings['email_enabled'] ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !$settings['email_enabled'] ? 'selected' : '' }}>Disabled</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="sms_enabled">SMS Notifications</label>
                        <select name="sms_enabled" id="sms_enabled" class="form-control">
                            <option value="1" {{ $settings['sms_enabled'] ? 'selected' : '' }}>Enabled</option>
                            <option value="0" {{ !$settings['sms_enabled'] ? 'selected' : '' }}>Disabled</option>
                        </select>
                    </div>

                    <div class="form-group">
                        <label for="default_email_from">Default Email From</label>
                        <input type="email" name="default_email_from" id="default_email_from" 
                               value="{{ $settings['default_email_from'] }}" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label for="test_email">Test Email Address</label>
                        <input type="email" name="test_email" id="test_email" 
                               value="{{ $settings['test_email'] }}" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label for="test_phone">Test Phone Number</label>
                        <input type="text" name="test_phone" id="test_phone" 
                               value="{{ $settings['test_phone'] }}" class="form-control" required
                               placeholder="+1234567890">
                    </div>
                </div>

                <button type="submit" class="btn btn-primary">💾 Save Settings</button>
            </form>
        </div>

        <!-- Email Providers -->
        <div class="notification-section">
            <div class="section-header">
                <h2>📧 Email Providers</h2>
                <a href="{{ route('admin.notifications.providers.create', ['type' => 'email']) }}" class="btn btn-success">
                    ➕ Add Email Provider
                </a>
            </div>

            @if($emailProviders->count() > 0)
                <div class="providers-grid">
                    @foreach($emailProviders as $provider)
                        <div class="provider-card {{ $provider->is_active ? 'active' : 'inactive' }}">
                            <div class="provider-header">
                                <h3>{{ $provider->display_name }}</h3>
                                <div class="provider-badges">
                                    @if($provider->is_default)
                                        <span class="badge badge-primary">Default</span>
                                    @endif
                                    @if($provider->is_active)
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-secondary">Inactive</span>
                                    @endif
                                </div>
                            </div>

                            <div class="provider-info">
                                <p><strong>Provider:</strong> {{ ucfirst($provider->name) }}</p>
                                <p><strong>Priority:</strong> {{ $provider->priority }}</p>
                                @if($provider->last_tested_at)
                                    <p><strong>Last Tested:</strong> {{ $provider->last_tested_at->diffForHumans() }}</p>
                                    @if($provider->test_results)
                                        <p class="test-result {{ $provider->test_results['success'] ? 'success' : 'error' }}">
                                            <strong>Test Result:</strong> {{ $provider->test_results['message'] }}
                                        </p>
                                    @endif
                                @else
                                    <p class="test-result warning"><strong>Status:</strong> Not tested</p>
                                @endif
                            </div>

                            <div class="provider-actions">
                                <a href="{{ route('admin.notifications.providers.edit', $provider) }}" class="btn btn-sm btn-outline-primary">
                                    ✏️ Edit
                                </a>
                                
                                <form action="{{ route('admin.notifications.providers.test', $provider) }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-outline-info">🧪 Test</button>
                                </form>

                                <form action="{{ route('admin.notifications.providers.toggle', $provider) }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm {{ $provider->is_active ? 'btn-outline-warning' : 'btn-outline-success' }}">
                                        {{ $provider->is_active ? '⏸️ Deactivate' : '▶️ Activate' }}
                                    </button>
                                </form>

                                @if($provider->is_active && !$provider->is_default)
                                    <form action="{{ route('admin.notifications.providers.default', $provider) }}" method="POST" style="display: inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-outline-primary">⭐ Set Default</button>
                                    </form>
                                @endif

                                @if(!$provider->is_default)
                                    <form action="{{ route('admin.notifications.providers.delete', $provider) }}" method="POST" style="display: inline;" 
                                          onsubmit="return confirm('Are you sure you want to delete this provider?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger">🗑️ Delete</button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="empty-state">
                    <p>No email providers configured. Add one to start sending email notifications.</p>
                </div>
            @endif
        </div>

        <!-- SMS Providers -->
        <div class="notification-section">
            <div class="section-header">
                <h2>📱 SMS Providers</h2>
                <a href="{{ route('admin.notifications.providers.create', ['type' => 'sms']) }}" class="btn btn-success">
                    ➕ Add SMS Provider
                </a>
            </div>

            @if($smsProviders->count() > 0)
                <div class="providers-grid">
                    @foreach($smsProviders as $provider)
                        <div class="provider-card {{ $provider->is_active ? 'active' : 'inactive' }}">
                            <div class="provider-header">
                                <h3>{{ $provider->display_name }}</h3>
                                <div class="provider-badges">
                                    @if($provider->is_default)
                                        <span class="badge badge-primary">Default</span>
                                    @endif
                                    @if($provider->is_active)
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-secondary">Inactive</span>
                                    @endif
                                </div>
                            </div>

                            <div class="provider-info">
                                <p><strong>Provider:</strong> {{ ucfirst($provider->name) }}</p>
                                <p><strong>Priority:</strong> {{ $provider->priority }}</p>
                                @if($provider->last_tested_at)
                                    <p><strong>Last Tested:</strong> {{ $provider->last_tested_at->diffForHumans() }}</p>
                                    @if($provider->test_results)
                                        <p class="test-result {{ $provider->test_results['success'] ? 'success' : 'error' }}">
                                            <strong>Test Result:</strong> {{ $provider->test_results['message'] }}
                                        </p>
                                    @endif
                                @else
                                    <p class="test-result warning"><strong>Status:</strong> Not tested</p>
                                @endif
                            </div>

                            <div class="provider-actions">
                                <a href="{{ route('admin.notifications.providers.edit', $provider) }}" class="btn btn-sm btn-outline-primary">
                                    ✏️ Edit
                                </a>
                                
                                <form action="{{ route('admin.notifications.providers.test', $provider) }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm btn-outline-info">🧪 Test</button>
                                </form>

                                <form action="{{ route('admin.notifications.providers.toggle', $provider) }}" method="POST" style="display: inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm {{ $provider->is_active ? 'btn-outline-warning' : 'btn-outline-success' }}">
                                        {{ $provider->is_active ? '⏸️ Deactivate' : '▶️ Activate' }}
                                    </button>
                                </form>

                                @if($provider->is_active && !$provider->is_default)
                                    <form action="{{ route('admin.notifications.providers.default', $provider) }}" method="POST" style="display: inline;">
                                        @csrf
                                        <button type="submit" class="btn btn-sm btn-outline-primary">⭐ Set Default</button>
                                    </form>
                                @endif

                                @if(!$provider->is_default)
                                    <form action="{{ route('admin.notifications.providers.delete', $provider) }}" method="POST" style="display: inline;" 
                                          onsubmit="return confirm('Are you sure you want to delete this provider?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger">🗑️ Delete</button>
                                    </form>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            @else
                <div class="empty-state">
                    <p>No SMS providers configured. Add one to start sending SMS notifications.</p>
                </div>
            @endif
        </div>
    </div>
</div>

<style>
.notification-section {
    background: rgba(0, 20, 40, 0.8);
    border: 1px solid #333;
    border-radius: 10px;
    padding: 1.5rem;
    margin-bottom: 2rem;
}

.section-header {
    display: flex;
    justify-content: between;
    align-items: center;
    margin-bottom: 1.5rem;
}

.section-header h2 {
    color: #fff;
    margin: 0;
}

.settings-form .form-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
    gap: 1rem;
    margin-bottom: 1.5rem;
}

.providers-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
    gap: 1.5rem;
}

.provider-card {
    background: rgba(0, 30, 60, 0.6);
    border: 1px solid #444;
    border-radius: 8px;
    padding: 1.5rem;
    transition: all 0.3s ease;
}

.provider-card.active {
    border-color: #28a745;
    box-shadow: 0 0 10px rgba(40, 167, 69, 0.3);
}

.provider-card.inactive {
    border-color: #6c757d;
    opacity: 0.7;
}

.provider-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 1rem;
}

.provider-header h3 {
    color: #fff;
    margin: 0;
}

.provider-badges {
    display: flex;
    gap: 0.5rem;
}

.badge {
    padding: 0.25rem 0.5rem;
    border-radius: 4px;
    font-size: 0.75rem;
    font-weight: 600;
}

.badge-primary { background: #007bff; color: white; }
.badge-success { background: #28a745; color: white; }
.badge-secondary { background: #6c757d; color: white; }

.provider-info p {
    color: #ccc;
    margin: 0.5rem 0;
}

.test-result.success { color: #28a745; }
.test-result.error { color: #dc3545; }
.test-result.warning { color: #ffc107; }

.provider-actions {
    display: flex;
    flex-wrap: wrap;
    gap: 0.5rem;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid #444;
}

.provider-actions .btn {
    font-size: 0.8rem;
    padding: 0.375rem 0.75rem;
}

.empty-state {
    text-align: center;
    padding: 3rem;
    color: #6c757d;
}

.alert {
    padding: 1rem;
    margin-bottom: 1rem;
    border-radius: 4px;
}

.alert-success {
    background: rgba(40, 167, 69, 0.1);
    border: 1px solid #28a745;
    color: #28a745;
}

.alert-danger {
    background: rgba(220, 53, 69, 0.1);
    border: 1px solid #dc3545;
    color: #dc3545;
}
</style>
@endsection