@extends('layouts.app')

@section('title', 'View Popup Notification')

@section('content')
<div class="admin-view-notification">
    <div class="container">
        <div class="header-section">
            <div class="header-content">
                <h1>👁️ View Popup Notification</h1>
                <p>Notification details and management</p>
            </div>
            <div class="header-actions">
                <a href="{{ route('admin.popup-notifications.index') }}" class="btn-secondary">
                    ← Back to Notifications
                </a>
                <a href="{{ route('admin.popup-notifications.edit', $popupNotification) }}" class="btn-warning">
                    ✏️ Edit Notification
                </a>
                <form method="POST" action="{{ route('admin.popup-notifications.toggle', $popupNotification) }}" style="display: inline;">
                    @csrf
                    <button type="submit" class="btn-{{ $popupNotification->is_active ? 'secondary' : 'success' }}">
                        {{ $popupNotification->is_active ? '🔕 Deactivate' : '🔔 Activate' }}
                    </button>
                </form>
            </div>
        </div>

        <div class="notification-grid">
            <!-- Notification Details -->
            <div class="main-content">
                <div class="notification-section">
                    <div class="notification-header">
                        <div class="notification-meta">
                            <span class="notification-type type-{{ $popupNotification->type }}">
                                {{ $popupNotification->icon }} {{ ucfirst($popupNotification->type) }}
                            </span>
                            <span class="notification-status status-{{ $popupNotification->is_active ? 'active' : 'inactive' }}">
                                {{ $popupNotification->is_active ? 'Active' : 'Inactive' }}
                            </span>
                        </div>

                        <h1 class="notification-title">{{ $popupNotification->title }}</h1>
                    </div>

                    <div class="notification-content">
                        <h3>📝 Message</h3>
                        <div class="message-content">
                            {{ $popupNotification->message }}
                        </div>
                    </div>

                    <div class="notification-preview">
                        <h3>👁️ Preview</h3>
                        <div class="preview-wrapper">
                            <div class="preview-notification">
                                <div class="preview-header">
                                    <span class="preview-icon">{{ $popupNotification->icon }}</span>
                                    <span class="preview-title">{{ $popupNotification->title }}</span>
                                    <button class="preview-close">&times;</button>
                                </div>
                                <div class="preview-body">
                                    <p class="preview-message">{{ $popupNotification->message }}</p>
                                </div>
                                <div class="preview-actions">
                                    <button class="preview-btn">Got it!</button>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="targeting-info">
                        <h3>🎯 Targeting Information</h3>
                        <div class="targeting-details">
                            @if($popupNotification->target_users)
                                @if(isset($popupNotification->target_users['levels']))
                                    <div class="target-item">
                                        <span class="target-label">Target Levels:</span>
                                        <span class="target-value">{{ implode(', ', $popupNotification->target_users['levels']) }}</span>
                                    </div>
                                @endif

                                @if(isset($popupNotification->target_users['min_level']))
                                    <div class="target-item">
                                        <span class="target-label">Minimum Level:</span>
                                        <span class="target-value">Level {{ $popupNotification->target_users['min_level'] }}+</span>
                                    </div>
                                @endif

                                @if(isset($popupNotification->target_users['user_ids']))
                                    @php
                                        $targetUsernames = \App\Models\User::whereIn('id', $popupNotification->target_users['user_ids'])->pluck('username')->toArray();
                                    @endphp
                                    <div class="target-item">
                                        <span class="target-label">Target Users:</span>
                                        <span class="target-value">{{ implode(', ', $targetUsernames) }}</span>
                                    </div>
                                @endif
                            @else
                                <div class="target-item">
                                    <span class="target-label">Target Audience:</span>
                                    <span class="target-value all-users">All Users</span>
                                </div>
                            @endif
                        </div>
                    </div>

                    @if($popupNotification->start_date || $popupNotification->end_date)
                        <div class="schedule-info">
                            <h3>📅 Schedule</h3>
                            <div class="schedule-details">
                                @if($popupNotification->start_date)
                                    <div class="schedule-item">
                                        <span class="schedule-label">Start Date:</span>
                                        <span class="schedule-value">{{ $popupNotification->start_date->format('F j, Y \a\t g:i A') }}</span>
                                        @if($popupNotification->start_date > now())
                                            <span class="schedule-status future">⏳ Scheduled</span>
                                        @else
                                            <span class="schedule-status active">✅ Active</span>
                                        @endif
                                    </div>
                                @endif

                                @if($popupNotification->end_date)
                                    <div class="schedule-item">
                                        <span class="schedule-label">End Date:</span>
                                        <span class="schedule-value">{{ $popupNotification->end_date->format('F j, Y \a\t g:i A') }}</span>
                                        @if($popupNotification->end_date < now())
                                            <span class="schedule-status expired">❌ Expired</span>
                                        @else
                                            <span class="schedule-status active">⏰ Active</span>
                                        @endif
                                    </div>
                                @endif
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <!-- Sidebar -->
            <div class="sidebar">
                <div class="stats-section">
                    <h3>📊 Statistics</h3>
                    <div class="stats-grid">
                        <div class="stat-item">
                            <span class="stat-label">Views</span>
                            <span class="stat-value">{{ $popupNotification->seenBy()->count() }}</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Created By</span>
                            <span class="stat-value">{{ $popupNotification->creator->username }}</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Created</span>
                            <span class="stat-value">{{ $popupNotification->created_at->format('M j, Y') }}</span>
                        </div>
                        <div class="stat-item">
                            <span class="stat-label">Last Updated</span>
                            <span class="stat-value">{{ $popupNotification->updated_at->format('M j, Y') }}</span>
                        </div>
                    </div>
                </div>

                <div class="actions-section">
                    <h3>⚡ Quick Actions</h3>
                    <div class="action-buttons">
                        <a href="{{ route('admin.popup-notifications.edit', $popupNotification) }}" class="action-btn btn-warning">
                            ✏️ Edit Notification
                        </a>

                        <form method="POST" action="{{ route('admin.popup-notifications.toggle', $popupNotification) }}">
                            @csrf
                            <button type="submit" class="action-btn btn-{{ $popupNotification->is_active ? 'secondary' : 'success' }}">
                                {{ $popupNotification->is_active ? '🔕 Deactivate' : '🔔 Activate' }}
                            </button>
                        </form>

                        <form method="POST" action="{{ route('admin.popup-notifications.destroy', $popupNotification) }}" 
                              onsubmit="return confirm('Are you sure you want to delete this notification? This action cannot be undone.')">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="action-btn btn-danger">
                                🗑️ Delete Notification
                            </button>
                        </form>
                    </div>
                </div>

                @if($popupNotification->seenBy()->count() > 0)
                    <div class="viewers-section">
                        <h3>👥 Recent Viewers</h3>
                        <div class="viewers-list">
                            @foreach($popupNotification->seenBy()->latest('pivot_seen_at')->limit(10)->get() as $user)
                                <div class="viewer-item">
                                    <div class="viewer-avatar">
                                        {{ substr($user->username, 0, 1) }}
                                    </div>
                                    <div class="viewer-info">
                                        <span class="viewer-name">{{ $user->username }}</span>
                                        <span class="viewer-time">{{ $user->pivot->seen_at->diffForHumans() }}</span>
                                    </div>
                                </div>
                            @endforeach
                        </div>
                        @if($popupNotification->seenBy()->count() > 10)
                            <div class="viewers-more">
                                +{{ $popupNotification->seenBy()->count() - 10 }} more viewers
                            </div>
                        @endif
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<style>
.admin-view-notification {
    padding: 2rem 0;
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    min-height: 100vh;
    color: #e2e8f0;
}

.header-section {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 2rem;
    padding: 1.5rem;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 12px;
}

.header-content h1 {
    color: #ff6600;
    margin: 0 0 0.5rem 0;
    font-size: 2rem;
}

.header-content p {
    color: #94a3b8;
    margin: 0;
}

.header-actions {
    display: flex;
    gap: 1rem;
    flex-wrap: wrap;
}

.btn-secondary, .btn-warning, .btn-success {
    padding: 0.75rem 1.5rem;
    border-radius: 8px;
    font-weight: 600;
    transition: all 0.3s ease;
    border: 1px solid;
    cursor: pointer;
    text-decoration: none;
}

.btn-secondary {
    background: rgba(255, 102, 0, 0.2);
    color: #ff6600;
    border-color: #ff6600;
}

.btn-secondary:hover {
    background: #ff6600;
    color: #1a1a2e;
}

.btn-warning {
    background: rgba(245, 158, 11, 0.2);
    color: #f59e0b;
    border-color: #f59e0b;
}

.btn-warning:hover {
    background: #f59e0b;
    color: #1a1a2e;
}

.btn-success {
    background: rgba(34, 197, 94, 0.2);
    color: #22c55e;
    border-color: #22c55e;
}

.btn-success:hover {
    background: #22c55e;
    color: white;
}

.notification-grid {
    display: grid;
    grid-template-columns: 2fr 1fr;
    gap: 2rem;
}

.notification-section {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 2rem;
}

.notification-section > div {
    margin-bottom: 2rem;
}

.notification-section > div:last-child {
    margin-bottom: 0;
}

.notification-header {
    margin-bottom: 2rem;
}

.notification-meta {
    display: flex;
    gap: 1rem;
    margin-bottom: 1.5rem;
    flex-wrap: wrap;
}

.notification-type,
.notification-status {
    padding: 0.5rem 1rem;
    border-radius: 20px;
    font-size: 0.9rem;
    font-weight: 600;
}

.type-info { background: rgba(59, 130, 246, 0.2); color: #3b82f6; }
.type-warning { background: rgba(245, 158, 11, 0.2); color: #f59e0b; }
.type-success { background: rgba(34, 197, 94, 0.2); color: #22c55e; }
.type-announcement { background: rgba(236, 72, 153, 0.2); color: #ec4899; }

.status-active { background: rgba(34, 197, 94, 0.2); color: #22c55e; }
.status-inactive { background: rgba(107, 114, 128, 0.2); color: #6b7280; }

.notification-title {
    color: #e2e8f0;
    font-size: 2rem;
    font-weight: 700;
    margin: 0;
    line-height: 1.3;
}

.notification-section h3 {
    color: #ff6600;
    margin-bottom: 1rem;
    font-size: 1.2rem;
}

.message-content {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
    padding: 1.5rem;
    font-size: 1.1rem;
    line-height: 1.6;
    color: #e2e8f0;
}

.preview-wrapper {
    display: flex;
    justify-content: center;
    padding: 2rem;
    background: rgba(0, 0, 0, 0.3);
    border-radius: 12px;
}

.preview-notification {
    background: linear-gradient(135deg, #1a1a2e 0%, #16213e 100%);
    border: 2px solid rgba(255, 102, 0, 0.3);
    border-radius: 16px;
    max-width: 400px;
    width: 100%;
    overflow: hidden;
}

.preview-header {
    display: flex;
    align-items: center;
    gap: 1rem;
    padding: 1.5rem;
    background: rgba(255, 102, 0, 0.1);
    border-bottom: 1px solid rgba(255, 102, 0, 0.2);
}

.preview-icon {
    font-size: 1.5rem;
}

.preview-title {
    color: #ff6600;
    font-weight: 600;
    font-size: 1.2rem;
    flex: 1;
}

.preview-close {
    background: none;
    border: none;
    color: #94a3b8;
    font-size: 1.5rem;
    cursor: pointer;
    width: 32px;
    height: 32px;
    display: flex;
    align-items: center;
    justify-content: center;
    border-radius: 50%;
    transition: all 0.3s ease;
}

.preview-close:hover {
    background: rgba(255, 255, 255, 0.1);
    color: #e2e8f0;
}

.preview-body {
    padding: 1.5rem;
}

.preview-message {
    color: #e2e8f0;
    line-height: 1.6;
    margin: 0;
}

.preview-actions {
    padding: 1.5rem;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
    text-align: center;
}

.preview-btn {
    background: linear-gradient(135deg, #ff6600, #cc5500);
    color: white;
    border: none;
    padding: 0.75rem 2rem;
    border-radius: 25px;
    font-weight: 600;
    cursor: pointer;
}

.targeting-details,
.schedule-details {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.target-item,
.schedule-item {
    display: flex;
    justify-content: space-between;
    align-items: center;
    padding: 1rem;
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 8px;
}

.target-label,
.schedule-label {
    color: #94a3b8;
    font-weight: 500;
}

.target-value,
.schedule-value {
    color: #e2e8f0;
    font-weight: 600;
    text-align: right;
}

.all-users {
    color: #ff6600 !important;
}

.schedule-status {
    padding: 0.25rem 0.75rem;
    border-radius: 15px;
    font-size: 0.8rem;
    font-weight: 600;
    margin-left: 1rem;
}

.schedule-status.future { background: rgba(245, 158, 11, 0.2); color: #f59e0b; }
.schedule-status.active { background: rgba(34, 197, 94, 0.2); color: #22c55e; }
.schedule-status.expired { background: rgba(239, 68, 68, 0.2); color: #ef4444; }

.sidebar > div {
    background: rgba(255, 255, 255, 0.05);
    border: 1px solid rgba(255, 255, 255, 0.1);
    border-radius: 12px;
    padding: 1.5rem;
    margin-bottom: 2rem;
}

.sidebar h3 {
    color: #ff6600;
    margin: 0 0 1.5rem 0;
    font-size: 1.2rem;
}

.stats-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
    gap: 1rem;
}

.stat-item {
    text-align: center;
    padding: 1rem;
    background: rgba(255, 102, 0, 0.1);
    border: 1px solid rgba(255, 102, 0, 0.2);
    border-radius: 8px;
}

.stat-label {
    display: block;
    color: #94a3b8;
    font-size: 0.875rem;
    margin-bottom: 0.5rem;
}

.stat-value {
    display: block;
    color: #ff6600;
    font-weight: 600;
    font-size: 1.1rem;
}

.action-buttons {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.action-btn {
    padding: 0.75rem 1rem;
    border-radius: 8px;
    font-weight: 600;
    text-align: center;
    transition: all 0.3s ease;
    border: 1px solid;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 0.5rem;
    text-decoration: none;
}

.btn-danger {
    background: rgba(239, 68, 68, 0.2);
    color: #ef4444;
    border-color: #ef4444;
}

.btn-danger:hover {
    background: #ef4444;
    color: white;
}

.viewers-list {
    display: flex;
    flex-direction: column;
    gap: 1rem;
}

.viewer-item {
    display: flex;
    align-items: center;
    gap: 1rem;
}

.viewer-avatar {
    width: 32px;
    height: 32px;
    background: linear-gradient(135deg, #ff6600, #cc5500);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-weight: 600;
    font-size: 0.9rem;
}

.viewer-info {
    display: flex;
    flex-direction: column;
}

.viewer-name {
    color: #e2e8f0;
    font-weight: 500;
    font-size: 0.9rem;
}

.viewer-time {
    color: #94a3b8;
    font-size: 0.8rem;
}

.viewers-more {
    text-align: center;
    color: #94a3b8;
    font-size: 0.9rem;
    margin-top: 1rem;
    padding-top: 1rem;
    border-top: 1px solid rgba(255, 255, 255, 0.1);
}

@media (max-width: 1024px) {
    .notification-grid {
        grid-template-columns: 1fr;
    }
    
    .header-section {
        flex-direction: column;
        gap: 1rem;
        text-align: center;
    }
    
    .header-actions {
        justify-content: center;
    }
}

@media (max-width: 768px) {
    .notification-meta {
        flex-direction: column;
        align-items: flex-start;
    }
    
    .stats-grid {
        grid-template-columns: repeat(auto-fit, minmax(100px, 1fr));
    }
    
    .target-item,
    .schedule-item {
        flex-direction: column;
        align-items: flex-start;
        gap: 0.5rem;
    }
    
    .target-value,
    .schedule-value {
        text-align: left;
    }
}
</style>
@endsection