@extends('layouts.app')

@section('title', $groupTitle)

@section('content')
<div class="min-h-screen bg-cod-black text-white">
    <!-- Header -->
    <div class="bg-gradient-to-r from-cod-dark to-black border-b border-cod-green/20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-6">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-cod-green rounded-lg flex items-center justify-center">
                            <span class="text-xl text-black">⚙️</span>
                        </div>
                        <h1 class="text-xl font-gaming font-bold text-cod-green">{{ $groupTitle }}</h1>
                    </div>
                    
                    <nav class="hidden md:flex space-x-6">
                        <a href="{{ route('admin.dashboard') }}" class="advanced-menu-item">Dashboard</a>
                        <a href="{{ route('admin.settings.index') }}" class="advanced-menu-item">Settings</a>
                    </nav>
                </div>
                
                <div class="flex items-center">
                    <a href="{{ route('admin.settings.index') }}" class="btn-secondary px-4 py-2">
                        ← Back to Settings
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="py-8">
        <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="mb-8">
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">{{ $groupTitle }}</h1>
                <p class="text-gray-400 mt-2">
                    @switch($group)
                        @case('general')
                            Configure basic platform information and contact details
                            @break
                        @case('payment')
                            Set up payment gateway integrations and API credentials
                            @break
                        @case('api')
                            Configure third-party API integrations and services
                            @break
                        @case('security')
                            Manage security settings and authentication controls
                            @break
                        @case('platform')
                            Configure platform-specific settings and limits
                            @break
                        @case('features')
                            Enable or disable platform features
                            @break
                    @endswitch
                </p>
            </div>

            <form action="{{ route('admin.settings.group.update', $group) }}" method="POST" class="gaming-card rounded-lg p-8">
                @csrf
                @method('PUT')

                @if($group === 'general')
                    @include('admin.settings.groups.general')
                @elseif($group === 'payment')
                    @include('admin.settings.groups.payment')
                @elseif($group === 'api')
                    @include('admin.settings.groups.api')
                @elseif($group === 'security')
                    @include('admin.settings.groups.security')
                @elseif($group === 'platform')
                    @include('admin.settings.groups.platform')
                @elseif($group === 'features')
                    @include('admin.settings.groups.features')
                @endif

                <div class="flex items-center justify-between pt-6 border-t border-cod-green/20">
                    <div class="text-sm text-gray-400">
                        <span class="inline-flex items-center">
                            <span class="w-2 h-2 bg-cod-green rounded-full mr-2"></span>
                            Changes will take effect immediately after saving
                        </span>
                    </div>
                    <div class="flex space-x-3">
                        <a href="{{ route('admin.settings.index') }}" class="btn-secondary px-6 py-2">
                            Cancel
                        </a>
                        <button type="submit" class="btn-primary px-6 py-2">
                            💾 Save Settings
                        </button>
                    </div>
                </div>
            </form>

            <!-- Current Settings Display -->
            @if($settings->count() > 0)
            <div class="mt-8">
                <h2 class="text-xl font-bold text-cod-green mb-4">Current Configuration</h2>
                <div class="gaming-card rounded-lg p-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        @foreach($settings as $setting)
                        <div class="border border-cod-green/20 rounded p-3">
                            <div class="flex items-center justify-between mb-2">
                                <h4 class="font-medium text-cod-green">{{ str_replace('_', ' ', ucfirst($setting->key)) }}</h4>
                                @if($setting->is_encrypted)
                                    <span class="text-xs bg-red-600 text-white px-2 py-1 rounded">🔐 Encrypted</span>
                                @endif
                            </div>
                            <p class="text-gray-400 text-sm mb-2">{{ $setting->description }}</p>
                            <p class="text-white font-mono text-sm">
                                @if($setting->is_encrypted)
                                    ••••••••••••
                                @elseif($setting->type === 'boolean')
                                    {{ $setting->value ? 'Enabled' : 'Disabled' }}
                                @else
                                    {{ $setting->value ?: 'Not set' }}
                                @endif
                            </p>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
            @endif
        </div>
    </div>
</div>
@endsection