<!-- QoreID API Configuration -->
<div class="space-y-8">
    <div class="bg-cod-gray p-6 rounded-lg border border-cod-light">
        <div class="flex items-center space-x-2 mb-4">
            <div class="w-10 h-10 bg-blue-500 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">Q</span>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-white">QoreID API</h3>
                <p class="text-gray-400 text-sm">Identity verification and KYC services</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="qoreid_api_key" class="block text-sm font-medium text-gray-300 mb-2">API Key</label>
                <input type="text" 
                       id="qoreid_api_key" 
                       name="qoreid_api_key" 
                       value="{{ $settings->firstWhere('key', 'qoreid_api_key')?->value ?? '' }}"
                       placeholder="Enter QoreID API Key"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
            
            <div>
                <label for="qoreid_secret_key" class="block text-sm font-medium text-gray-300 mb-2">Secret Key</label>
                <input type="password" 
                       id="qoreid_secret_key" 
                       name="qoreid_secret_key" 
                       value="{{ $settings->firstWhere('key', 'qoreid_secret_key')?->value ?? '' }}"
                       placeholder="Enter QoreID Secret Key"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
            
            <div class="md:col-span-2">
                <label for="qoreid_base_url" class="block text-sm font-medium text-gray-300 mb-2">Base URL</label>
                <input type="url" 
                       id="qoreid_base_url" 
                       name="qoreid_base_url" 
                       value="{{ $settings->firstWhere('key', 'qoreid_base_url')?->value ?? 'https://api.qoreid.com' }}"
                       placeholder="https://api.qoreid.com"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
        </div>
        
        <div class="mt-4">
            <button type="button" onclick="testApiConnection('qoreid')" class="px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700 transition-colors">
                Test QoreID Connection
            </button>
        </div>
    </div>

    <!-- Twilio API Configuration -->
    <div class="bg-cod-gray p-6 rounded-lg border border-cod-light">
        <div class="flex items-center space-x-2 mb-4">
            <div class="w-10 h-10 bg-red-500 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">T</span>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-white">Twilio API</h3>
                <p class="text-gray-400 text-sm">SMS and voice communications</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="twilio_account_sid" class="block text-sm font-medium text-gray-300 mb-2">Account SID</label>
                <input type="text" 
                       id="twilio_account_sid" 
                       name="twilio_account_sid" 
                       value="{{ $settings->firstWhere('key', 'twilio_account_sid')?->value ?? '' }}"
                       placeholder="Enter Twilio Account SID"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
            
            <div>
                <label for="twilio_auth_token" class="block text-sm font-medium text-gray-300 mb-2">Auth Token</label>
                <input type="password" 
                       id="twilio_auth_token" 
                       name="twilio_auth_token" 
                       value="{{ $settings->firstWhere('key', 'twilio_auth_token')?->value ?? '' }}"
                       placeholder="Enter Twilio Auth Token"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
            
            <div class="md:col-span-2">
                <label for="twilio_phone_number" class="block text-sm font-medium text-gray-300 mb-2">Phone Number</label>
                <input type="tel" 
                       id="twilio_phone_number" 
                       name="twilio_phone_number" 
                       value="{{ $settings->firstWhere('key', 'twilio_phone_number')?->value ?? '' }}"
                       placeholder="+1234567890"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
        </div>
        
        <div class="mt-4">
            <button type="button" onclick="testApiConnection('twilio')" class="px-4 py-2 bg-red-600 text-white rounded-lg hover:bg-red-700 transition-colors">
                Test Twilio Connection
            </button>
        </div>
    </div>

    <!-- Firebase API Configuration -->
    <div class="bg-cod-gray p-6 rounded-lg border border-cod-light">
        <div class="flex items-center space-x-2 mb-4">
            <div class="w-10 h-10 bg-orange-500 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">F</span>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-white">Firebase API</h3>
                <p class="text-gray-400 text-sm">Push notifications and real-time database</p>
            </div>
        </div>
        
        <div>
            <label for="firebase_server_key" class="block text-sm font-medium text-gray-300 mb-2">Server Key</label>
            <textarea id="firebase_server_key" 
                      name="firebase_server_key" 
                      placeholder="Enter Firebase Server Key"
                      rows="3"
                      class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">{{ $settings->firstWhere('key', 'firebase_server_key')?->value ?? '' }}</textarea>
        </div>
        
        <div class="mt-4">
            <button type="button" onclick="testApiConnection('firebase')" class="px-4 py-2 bg-orange-600 text-white rounded-lg hover:bg-orange-700 transition-colors">
                Test Firebase Connection
            </button>
        </div>
    </div>

    <!-- Pusher API Configuration -->
    <div class="bg-cod-gray p-6 rounded-lg border border-cod-light">
        <div class="flex items-center space-x-2 mb-4">
            <div class="w-10 h-10 bg-purple-500 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">P</span>
            </div>
            <div>
                <h3 class="text-lg font-semibold text-white">Pusher API</h3>
                <p class="text-gray-400 text-sm">Real-time WebSocket connections</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="pusher_app_id" class="block text-sm font-medium text-gray-300 mb-2">App ID</label>
                <input type="text" 
                       id="pusher_app_id" 
                       name="pusher_app_id" 
                       value="{{ $settings->firstWhere('key', 'pusher_app_id')?->value ?? '' }}"
                       placeholder="Enter Pusher App ID"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
            
            <div>
                <label for="pusher_key" class="block text-sm font-medium text-gray-300 mb-2">Key</label>
                <input type="text" 
                       id="pusher_key" 
                       name="pusher_key" 
                       value="{{ $settings->firstWhere('key', 'pusher_key')?->value ?? '' }}"
                       placeholder="Enter Pusher Key"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
            
            <div>
                <label for="pusher_secret" class="block text-sm font-medium text-gray-300 mb-2">Secret</label>
                <input type="password" 
                       id="pusher_secret" 
                       name="pusher_secret" 
                       value="{{ $settings->firstWhere('key', 'pusher_secret')?->value ?? '' }}"
                       placeholder="Enter Pusher Secret"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
            
            <div>
                <label for="pusher_cluster" class="block text-sm font-medium text-gray-300 mb-2">Cluster</label>
                <input type="text" 
                       id="pusher_cluster" 
                       name="pusher_cluster" 
                       value="{{ $settings->firstWhere('key', 'pusher_cluster')?->value ?? 'us2' }}"
                       placeholder="us2"
                       class="w-full px-3 py-2 bg-cod-dark border border-cod-light rounded-lg text-gray-100 placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            </div>
        </div>
        
        <div class="mt-4">
            <button type="button" onclick="testApiConnection('pusher')" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition-colors">
                Test Pusher Connection
            </button>
        </div>
    </div>
</div>

<script>
function testApiConnection(provider) {
    const button = event.target;
    const originalText = button.textContent;
    
    button.disabled = true;
    button.textContent = 'Testing...';
    
    fetch('{{ route("admin.settings.test") }}', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },
        body: JSON.stringify({
            type: 'api',
            provider: provider
        })
    })
    .then(response => response.json())
    .then(data => {
        button.disabled = false;
        button.textContent = originalText;
        
        if (data.success) {
            showToast('Success: ' + data.message, 'success');
        } else {
            showToast('Error: ' + data.message, 'error');
        }
    })
    .catch(error => {
        button.disabled = false;
        button.textContent = originalText;
        showToast('Network error occurred', 'error');
    });
}

function showToast(message, type) {
    // Simple toast notification
    const toast = document.createElement('div');
    toast.className = `fixed top-4 right-4 px-6 py-3 rounded-lg text-white z-50 ${type === 'success' ? 'bg-green-600' : 'bg-red-600'}`;
    toast.textContent = message;
    document.body.appendChild(toast);
    
    setTimeout(() => {
function getToastContainer() {
    let container = document.getElementById('toast-container');
    if (!container) {
        container = document.createElement('div');
        container.id = 'toast-container';
        container.style.position = 'fixed';
        container.style.top = '1rem';
        container.style.right = '1rem';
        container.style.zIndex = '9999';
        container.style.display = 'flex';
        container.style.flexDirection = 'column';
        container.style.gap = '0.5rem';
        document.body.appendChild(container);
    }
    return container;
}

function showToast(message, type) {
    // Robust toast notification with container
    const toast = document.createElement('div');
    toast.className = `px-6 py-3 rounded-lg text-white shadow-lg transition-opacity duration-300 ${type === 'success' ? 'bg-green-600' : 'bg-red-600'}`;
    toast.textContent = message;
    toast.style.opacity = '1';

    const container = getToastContainer();
    container.appendChild(toast);

    setTimeout(() => {
        toast.style.opacity = '0';
        setTimeout(() => {
            if (toast.parentNode) {
                toast.parentNode.removeChild(toast);
            }
        }, 300);
    }, 5000);
}
</script>