{{-- Feature Settings Form --}}
<div class="space-y-6">
    <div class="bg-green-600/10 border border-green-600/30 rounded-lg p-4">
        <div class="flex items-center space-x-2">
            <span class="text-green-400">🎮</span>
            <p class="text-green-200 text-sm">
                <strong>Feature Controls:</strong> Enable or disable platform features to customize user experience and functionality.
            </p>
        </div>
    </div>

    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2">Gaming Features</h3>
    
    <div class="space-y-4">
        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center">
                    <span class="text-white">⚔️</span>
                </div>
                <div>
                    <h4 class="font-medium text-white">Challenge System</h4>
                    <p class="text-gray-400 text-sm">Enable 1v1 gaming challenges with wagers</p>
                </div>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="challenges_enabled" 
                       value="1"
                       {{ old('challenges_enabled', $settings->firstWhere('key', 'challenges_enabled')->value ?? true) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>

        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-purple-600 rounded-lg flex items-center justify-center">
                    <span class="text-white">🏆</span>
                </div>
                <div>
                    <h4 class="font-medium text-white">Tournament System</h4>
                    <p class="text-gray-400 text-sm">Enable tournament creation and participation</p>
                </div>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="tournaments_enabled" 
                       value="1"
                       {{ old('tournaments_enabled', $settings->firstWhere('key', 'tournaments_enabled')->value ?? true) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>

        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center">
                    <span class="text-white">📈</span>
                </div>
                <div>
                    <h4 class="font-medium text-white">Level System</h4>
                    <p class="text-gray-400 text-sm">Enable XP and level progression system</p>
                </div>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="level_system_enabled" 
                       value="1"
                       {{ old('level_system_enabled', $settings->firstWhere('key', 'level_system_enabled')->value ?? true) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>
    </div>

    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2 mt-8">Financial Features</h3>
    
    <div class="space-y-4">
        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-green-600 rounded-lg flex items-center justify-center">
                    <span class="text-white">💰</span>
                </div>
                <div>
                    <h4 class="font-medium text-white">Wallet System</h4>
                    <p class="text-gray-400 text-sm">Enable deposit, withdrawal, and transaction management</p>
                </div>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="wallet_enabled" 
                       value="1"
                       {{ old('wallet_enabled', $settings->firstWhere('key', 'wallet_enabled')->value ?? true) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>

        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 bg-orange-600 rounded-lg flex items-center justify-center">
                    <span class="text-white">🤝</span>
                </div>
                <div>
                    <h4 class="font-medium text-white">Referral System</h4>
                    <p class="text-gray-400 text-sm">Enable user referrals and rewards program</p>
                </div>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="referral_enabled" 
                       value="1"
                       {{ old('referral_enabled', $settings->firstWhere('key', 'referral_enabled')->value ?? false) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>
    </div>

    <div class="border border-cod-green/20 rounded-lg p-6 bg-cod-green/5">
        <h3 class="text-lg font-bold text-cod-green mb-4">Feature Dependencies</h3>
        <div class="space-y-3 text-sm">
            <div class="flex items-start space-x-2">
                <span class="text-yellow-400 mt-1">⚠️</span>
                <p class="text-gray-300"><strong>Challenges require Wallet:</strong> Users need funds to create wagers</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-yellow-400 mt-1">⚠️</span>
                <p class="text-gray-300"><strong>Tournaments may require Wallet:</strong> For entry fees and prize distribution</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-blue-400 mt-1">💡</span>
                <p class="text-gray-300"><strong>Level System:</strong> Affects permissions for features and actions</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-green-400 mt-1">✓</span>
                <p class="text-gray-300"><strong>Independent Features:</strong> Can be disabled without affecting others</p>
            </div>
        </div>
    </div>

    <div class="border border-blue-600/30 rounded-lg p-4 bg-blue-600/10">
        <div class="flex items-center space-x-2">
            <span class="text-blue-400">💡</span>
            <p class="text-blue-200 text-sm">
                <strong>Performance Tip:</strong> Disabling unused features can improve platform performance and reduce complexity for users.
            </p>
        </div>
    </div>
</div>