{{-- General Settings Form --}}
<div class="space-y-6">
    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2">Basic Information</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="platform_name" class="block text-sm font-medium text-gray-300 mb-2">Platform Name</label>
            <input type="text" 
                   id="platform_name" 
                   name="platform_name" 
                   value="{{ old('platform_name', $settings->firstWhere('key', 'platform_name')->value ?? 'BattleMania') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                   placeholder="Enter platform name">
            @error('platform_name')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="platform_logo" class="block text-sm font-medium text-gray-300 mb-2">Platform Logo URL</label>
            <input type="url" 
                   id="platform_logo" 
                   name="platform_logo" 
                   value="{{ old('platform_logo', $settings->firstWhere('key', 'platform_logo')->value ?? '') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                   placeholder="Enter logo URL">
            @error('platform_logo')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="currency" class="block text-sm font-medium text-gray-300 mb-2">Currency Symbol</label>
            <input type="text" 
                   id="currency" 
                   name="currency" 
                   value="{{ old('currency', $settings->firstWhere('key', 'currency')->value ?? '₦') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                   placeholder="Enter currency symbol">
            @error('currency')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <div>
        <label for="platform_description" class="block text-sm font-medium text-gray-300 mb-2">Platform Description</label>
        <textarea id="platform_description" 
                  name="platform_description" 
                  rows="3"
                  class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                  placeholder="Enter platform description">{{ old('platform_description', $settings->firstWhere('key', 'platform_description')->value ?? 'The ultimate gaming challenge platform for competitive players') }}</textarea>
        @error('platform_description')
            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
        @enderror
    </div>

    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2 mt-8">Contact Information</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="support_email" class="block text-sm font-medium text-gray-300 mb-2">Support Email</label>
            <input type="email" 
                   id="support_email" 
                   name="support_email" 
                   value="{{ old('support_email', $settings->firstWhere('key', 'support_email')->value ?? 'support@battlemania.com') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                   placeholder="Enter support email">
            @error('support_email')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="contact_phone" class="block text-sm font-medium text-gray-300 mb-2">Contact Phone</label>
            <input type="text" 
                   id="contact_phone" 
                   name="contact_phone" 
                   value="{{ old('contact_phone', $settings->firstWhere('key', 'contact_phone')->value ?? '') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                   placeholder="Enter contact phone number">
            @error('contact_phone')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <div>
        <label for="timezone" class="block text-sm font-medium text-gray-300 mb-2">Default Timezone</label>
        <select id="timezone" 
                name="timezone"
                class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            @php
                $currentTimezone = old('timezone', $settings->firstWhere('key', 'timezone')->value ?? 'UTC');
                $timezones = [
                    'UTC' => 'UTC (Coordinated Universal Time)',
                    'Africa/Lagos' => 'Africa/Lagos (WAT)',
                    'America/New_York' => 'America/New_York (EST/EDT)',
                    'America/Los_Angeles' => 'America/Los_Angeles (PST/PDT)',
                    'Europe/London' => 'Europe/London (GMT/BST)',
                    'Asia/Tokyo' => 'Asia/Tokyo (JST)',
                    'Australia/Sydney' => 'Australia/Sydney (AEST/AEDT)',
                ];
            @endphp
            @foreach($timezones as $tz => $label)
                <option value="{{ $tz }}" {{ $currentTimezone === $tz ? 'selected' : '' }}>
                    {{ $label }}
                </option>
            @endforeach
        </select>
        @error('timezone')
            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
        @enderror
    </div>
</div>