{{-- Payment Gateway Settings Form --}}
<div class="space-y-8">
    <div class="bg-yellow-600/10 border border-yellow-600/30 rounded-lg p-4">
        <div class="flex items-center space-x-2">
            <span class="text-yellow-400">⚠️</span>
            <p class="text-yellow-200 text-sm">
                <strong>Security Notice:</strong> API keys and secrets are encrypted and stored securely. Never share these credentials.
            </p>
        </div>
    </div>

    {{-- Paystack Configuration --}}
    <div class="border border-cod-green/20 rounded-lg p-6">
        <div class="flex items-center space-x-3 mb-4">
            <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">P</span>
            </div>
            <div>
                <h3 class="text-lg font-bold text-cod-green">Paystack</h3>
                <p class="text-gray-400 text-sm">Nigerian payment gateway</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="paystack_public_key" class="block text-sm font-medium text-gray-300 mb-2">Public Key</label>
                <input type="text" 
                       id="paystack_public_key" 
                       name="paystack_public_key" 
                       value="{{ old('paystack_public_key', $settings->firstWhere('key', 'paystack_public_key')->value ?? '') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="pk_test_...">
                @error('paystack_public_key')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            
            <div>
                <label for="paystack_secret_key" class="block text-sm font-medium text-gray-300 mb-2">Secret Key 🔐</label>
                <input type="password" 
                       id="paystack_secret_key" 
                       name="paystack_secret_key" 
                       value="{{ old('paystack_secret_key') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="sk_test_...">
                @error('paystack_secret_key')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
        </div>
    </div>

    {{-- Flutterwave Configuration --}}
    <div class="border border-cod-green/20 rounded-lg p-6">
        <div class="flex items-center space-x-3 mb-4">
            <div class="w-10 h-10 bg-orange-600 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">F</span>
            </div>
            <div>
                <h3 class="text-lg font-bold text-cod-green">Flutterwave</h3>
                <p class="text-gray-400 text-sm">African payment gateway</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="flutterwave_public_key" class="block text-sm font-medium text-gray-300 mb-2">Public Key</label>
                <input type="text" 
                       id="flutterwave_public_key" 
                       name="flutterwave_public_key" 
                       value="{{ old('flutterwave_public_key', $settings->firstWhere('key', 'flutterwave_public_key')->value ?? '') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="FLWPUBK_TEST-...">
                @error('flutterwave_public_key')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            
            <div>
                <label for="flutterwave_secret_key" class="block text-sm font-medium text-gray-300 mb-2">Secret Key 🔐</label>
                <input type="password" 
                       id="flutterwave_secret_key" 
                       name="flutterwave_secret_key" 
                       value="{{ old('flutterwave_secret_key') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="FLWSECK_TEST-...">
                @error('flutterwave_secret_key')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
        </div>
    </div>

    {{-- PayPal Configuration --}}
    <div class="border border-cod-green/20 rounded-lg p-6">
        <div class="flex items-center space-x-3 mb-4">
            <div class="w-10 h-10 bg-blue-700 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">PP</span>
            </div>
            <div>
                <h3 class="text-lg font-bold text-cod-green">PayPal</h3>
                <p class="text-gray-400 text-sm">Global payment platform</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="paypal_client_id" class="block text-sm font-medium text-gray-300 mb-2">Client ID</label>
                <input type="text" 
                       id="paypal_client_id" 
                       name="paypal_client_id" 
                       value="{{ old('paypal_client_id', $settings->firstWhere('key', 'paypal_client_id')->value ?? '') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="AYSq3RDGsmBLJE...">
                @error('paypal_client_id')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            
            <div>
                <label for="paypal_secret" class="block text-sm font-medium text-gray-300 mb-2">Client Secret 🔐</label>
                <input type="password" 
                       id="paypal_secret" 
                       name="paypal_secret" 
                       value="{{ old('paypal_secret') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="EHT4st...">
                @error('paypal_secret')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
        </div>
    </div>

    {{-- Stripe Configuration --}}
    <div class="border border-cod-green/20 rounded-lg p-6">
        <div class="flex items-center space-x-3 mb-4">
            <div class="w-10 h-10 bg-purple-600 rounded-lg flex items-center justify-center">
                <span class="text-white font-bold">S</span>
            </div>
            <div>
                <h3 class="text-lg font-bold text-cod-green">Stripe</h3>
                <p class="text-gray-400 text-sm">Global payment processor</p>
            </div>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label for="stripe_publishable_key" class="block text-sm font-medium text-gray-300 mb-2">Publishable Key</label>
                <input type="text" 
                       id="stripe_publishable_key" 
                       name="stripe_publishable_key" 
                       value="{{ old('stripe_publishable_key', $settings->firstWhere('key', 'stripe_publishable_key')->value ?? '') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="pk_test_...">
                @error('stripe_publishable_key')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
            
            <div>
                <label for="stripe_secret_key" class="block text-sm font-medium text-gray-300 mb-2">Secret Key 🔐</label>
                <input type="password" 
                       id="stripe_secret_key" 
                       name="stripe_secret_key" 
                       value="{{ old('stripe_secret_key') }}"
                       class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent"
                       placeholder="sk_test_...">
                @error('stripe_secret_key')
                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>
        </div>
    </div>

    {{-- Test Buttons --}}
    <div class="border border-cod-green/20 rounded-lg p-6 bg-cod-green/5">
        <h3 class="text-lg font-bold text-cod-green mb-4">Test Configurations</h3>
        <div class="grid grid-cols-2 md:grid-cols-4 gap-3">
            <button type="button" onclick="testPaymentGateway('paystack')" class="btn-secondary text-sm py-2">
                Test Paystack
            </button>
            <button type="button" onclick="testPaymentGateway('flutterwave')" class="btn-secondary text-sm py-2">
                Test Flutterwave
            </button>
            <button type="button" onclick="testPaymentGateway('paypal')" class="btn-secondary text-sm py-2">
                Test PayPal
            </button>
            <button type="button" onclick="testPaymentGateway('stripe')" class="btn-secondary text-sm py-2">
                Test Stripe
            </button>
        </div>
    </div>
</div>

<script>
function testPaymentGateway(provider) {
    const formData = new FormData();
    formData.append('type', 'payment');
    formData.append('provider', provider);

    fetch('{{ route("admin.settings.test") }}', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('✅ ' + data.message);
        } else {
            alert('❌ ' + data.message);
        }
    })
    .catch(error => {
        alert('❌ Test failed: ' + error.message);
    });
}
</script>