{{-- Platform Configuration Settings Form --}}
<div class="space-y-6">
    <div class="bg-blue-600/10 border border-blue-600/30 rounded-lg p-4">
        <div class="flex items-center space-x-2">
            <span class="text-blue-400">💡</span>
            <p class="text-blue-200 text-sm">
                <strong>Platform Settings:</strong> These settings control core platform behavior and financial operations.
            </p>
        </div>
    </div>

    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2">Financial Settings</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="commission_rate" class="block text-sm font-medium text-gray-300 mb-2">Commission Rate (%)</label>
            <input type="number" 
                   id="commission_rate" 
                   name="commission_rate" 
                   min="0" 
                   max="100"
                   step="0.01"
                   value="{{ old('commission_rate', $settings->firstWhere('key', 'commission_rate')->value ?? '5.0') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            <p class="text-gray-400 text-xs mt-1">Platform commission on all transactions</p>
            @error('commission_rate')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="minimum_deposit" class="block text-sm font-medium text-gray-300 mb-2">Minimum Deposit Amount</label>
            <input type="number" 
                   id="minimum_deposit" 
                   name="minimum_deposit" 
                   min="1"
                   step="0.01"
                   value="{{ old('minimum_deposit', $settings->firstWhere('key', 'minimum_deposit')->value ?? '10.00') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            <p class="text-gray-400 text-xs mt-1">Minimum amount users can deposit</p>
            @error('minimum_deposit')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="maximum_deposit" class="block text-sm font-medium text-gray-300 mb-2">Maximum Deposit Amount</label>
            <input type="number" 
                   id="maximum_deposit" 
                   name="maximum_deposit" 
                   min="1"
                   step="0.01"
                   value="{{ old('maximum_deposit', $settings->firstWhere('key', 'maximum_deposit')->value ?? '100000.00') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            <p class="text-gray-400 text-xs mt-1">Maximum amount users can deposit</p>
            @error('maximum_deposit')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="minimum_withdrawal" class="block text-sm font-medium text-gray-300 mb-2">Minimum Withdrawal Amount</label>
            <input type="number" 
                   id="minimum_withdrawal" 
                   name="minimum_withdrawal" 
                   min="1"
                   step="0.01"
                   value="{{ old('minimum_withdrawal', $settings->firstWhere('key', 'minimum_withdrawal')->value ?? '50.00') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            <p class="text-gray-400 text-xs mt-1">Minimum amount users can withdraw</p>
            @error('minimum_withdrawal')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <div>
        <label for="maximum_withdrawal" class="block text-sm font-medium text-gray-300 mb-2">Maximum Withdrawal Amount</label>
        <input type="number" 
               id="maximum_withdrawal" 
               name="maximum_withdrawal" 
               min="1"
               step="0.01"
               value="{{ old('maximum_withdrawal', $settings->firstWhere('key', 'maximum_withdrawal')->value ?? '50000.00') }}"
               class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
        <p class="text-gray-400 text-xs mt-1">Maximum amount users can withdraw</p>
        @error('maximum_withdrawal')
            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
        @enderror
    </div>

    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2 mt-8">Compliance Settings</h3>
    
    <div class="space-y-4">
        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div>
                <h4 class="font-medium text-white">KYC Required for Withdrawals</h4>
                <p class="text-gray-400 text-sm">Require identity verification before users can withdraw funds</p>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="kyc_required_for_withdrawal" 
                       value="1"
                       {{ old('kyc_required_for_withdrawal', $settings->firstWhere('key', 'kyc_required_for_withdrawal')->value ?? true) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>
    </div>

    <div class="border border-cod-green/20 rounded-lg p-6 bg-cod-green/5">
        <h3 class="text-lg font-bold text-cod-green mb-4">Financial Guidelines</h3>
        <div class="space-y-3 text-sm">
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">💰</span>
                <p class="text-gray-300"><strong>Commission Rate:</strong> Industry standard is 3-10%. Higher rates may deter users.</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">📊</span>
                <p class="text-gray-300"><strong>Deposit Limits:</strong> Balance accessibility with risk management.</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">🔒</span>
                <p class="text-gray-300"><strong>KYC Compliance:</strong> Required in most jurisdictions for financial platforms.</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">⚖️</span>
                <p class="text-gray-300"><strong>Legal Compliance:</strong> Ensure all settings comply with local regulations.</p>
            </div>
        </div>
    </div>

    <div class="border border-yellow-600/30 rounded-lg p-4 bg-yellow-600/10">
        <div class="flex items-center space-x-2">
            <span class="text-yellow-400">⚠️</span>
            <p class="text-yellow-200 text-sm">
                <strong>Important:</strong> Changes to financial settings may affect existing transactions. Consider user communication before making changes.
            </p>
        </div>
    </div>
</div>