{{-- Security Settings Form --}}
<div class="space-y-6">
    <div class="bg-red-600/10 border border-red-600/30 rounded-lg p-4">
        <div class="flex items-center space-x-2">
            <span class="text-red-400">🔒</span>
            <p class="text-red-200 text-sm">
                <strong>Security Warning:</strong> Changes to these settings will affect all users. Test carefully in a staging environment first.
            </p>
        </div>
    </div>

    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2">Authentication Settings</h3>
    
    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
        <div>
            <label for="max_login_attempts" class="block text-sm font-medium text-gray-300 mb-2">Max Login Attempts</label>
            <input type="number" 
                   id="max_login_attempts" 
                   name="max_login_attempts" 
                   min="1" 
                   max="20"
                   value="{{ old('max_login_attempts', $settings->firstWhere('key', 'max_login_attempts')->value ?? '5') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            <p class="text-gray-400 text-xs mt-1">Maximum failed login attempts before account lockout</p>
            @error('max_login_attempts')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>

        <div>
            <label for="session_lifetime" class="block text-sm font-medium text-gray-300 mb-2">Session Lifetime (minutes)</label>
            <input type="number" 
                   id="session_lifetime" 
                   name="session_lifetime" 
                   min="60" 
                   max="43200"
                   value="{{ old('session_lifetime', $settings->firstWhere('key', 'session_lifetime')->value ?? '120') }}"
                   class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
            <p class="text-gray-400 text-xs mt-1">How long user sessions remain active</p>
            @error('session_lifetime')
                <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
            @enderror
        </div>
    </div>

    <div>
        <label for="rate_limit_per_minute" class="block text-sm font-medium text-gray-300 mb-2">Rate Limit (requests per minute)</label>
        <input type="number" 
               id="rate_limit_per_minute" 
               name="rate_limit_per_minute" 
               min="10" 
               max="1000"
               value="{{ old('rate_limit_per_minute', $settings->firstWhere('key', 'rate_limit_per_minute')->value ?? '60') }}"
               class="w-full px-4 py-2 bg-cod-dark border border-cod-green/30 rounded-lg text-white focus:outline-none focus:ring-2 focus:ring-cod-green focus:border-transparent">
        <p class="text-gray-400 text-xs mt-1">Maximum API requests per minute per user</p>
        @error('rate_limit_per_minute')
            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
        @enderror
    </div>

    <h3 class="text-lg font-bold text-cod-green border-b border-cod-green/20 pb-2 mt-8">Advanced Security</h3>
    
    <div class="space-y-4">
        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div>
                <h4 class="font-medium text-white">Two-Factor Authentication</h4>
                <p class="text-gray-400 text-sm">Require 2FA for admin accounts</p>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="two_factor_enabled" 
                       value="1"
                       {{ old('two_factor_enabled', $settings->firstWhere('key', 'two_factor_enabled')->value ?? false) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>

        <div class="flex items-center justify-between p-4 border border-cod-green/20 rounded-lg">
            <div>
                <h4 class="font-medium text-white">IP Whitelist for Admin</h4>
                <p class="text-gray-400 text-sm">Restrict admin access to specific IP addresses</p>
            </div>
            <label class="relative inline-flex items-center cursor-pointer">
                <input type="checkbox" 
                       name="ip_whitelist_enabled" 
                       value="1"
                       {{ old('ip_whitelist_enabled', $settings->firstWhere('key', 'ip_whitelist_enabled')->value ?? false) ? 'checked' : '' }}
                       class="sr-only peer">
                <div class="w-11 h-6 bg-gray-700 peer-focus:outline-none peer-focus:ring-4 peer-focus:ring-cod-green/20 rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-cod-green"></div>
            </label>
        </div>
    </div>

    <div class="border border-cod-green/20 rounded-lg p-6 bg-cod-green/5">
        <h3 class="text-lg font-bold text-cod-green mb-4">Security Recommendations</h3>
        <div class="space-y-3 text-sm">
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">✓</span>
                <p class="text-gray-300">Enable HTTPS for all communications</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">✓</span>
                <p class="text-gray-300">Use strong passwords with minimum 8 characters</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">✓</span>
                <p class="text-gray-300">Enable two-factor authentication for all admin accounts</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">✓</span>
                <p class="text-gray-300">Regularly update application dependencies</p>
            </div>
            <div class="flex items-start space-x-2">
                <span class="text-cod-green mt-1">✓</span>
                <p class="text-gray-300">Monitor login attempts and suspicious activities</p>
            </div>
        </div>
    </div>
</div>