@extends('layouts.admin')

@section('title', 'System Settings')
@section('page-title', 'System Settings')
@section('page-subtitle', 'Configure platform settings and preferences')

@section('title', 'Platform Settings')

@section('content')
<div class="min-h-screen bg-cod-black text-white">
    <!-- Header -->
    <div class="bg-gradient-to-r from-cod-dark to-black border-b border-cod-green/20">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
            <div class="flex justify-between items-center">
                <div class="flex items-center space-x-6">
                    <div class="flex items-center space-x-3">
                        <div class="w-10 h-10 bg-cod-green rounded-lg flex items-center justify-center">
                            <span class="text-xl text-black">⚙️</span>
                        </div>
                        <h1 class="text-xl font-gaming font-bold text-cod-green">Platform Settings</h1>
                    </div>
                    
                    <nav class="hidden md:flex space-x-6">
                        <a href="{{ route('admin.dashboard') }}" class="advanced-menu-item">Dashboard</a>
                        <a href="{{ route('admin.users.index') }}" class="advanced-menu-item">Users</a>
                        <a href="{{ route('admin.games.index') }}" class="advanced-menu-item">Games</a>
                        <a href="{{ route('admin.challenges.index') }}" class="advanced-menu-item">Challenges</a>
                        <a href="{{ route('admin.tournaments.index') }}" class="advanced-menu-item">Tournaments</a>
                        <a href="{{ route('admin.posts.index') }}" class="advanced-menu-item">Content</a>
                        <a href="{{ route('admin.notifications.index') }}" class="advanced-menu-item">Notifications</a>
                        <a href="{{ route('admin.popup-notifications.index') }}" class="advanced-menu-item">Popups</a>
                        <a href="{{ route('admin.disputes.index') }}" class="advanced-menu-item">Disputes</a>
                        <a href="{{ route('admin.settings.index') }}" class="advanced-menu-item active">Settings</a>
                    </nav>
                </div>
                
                <div class="flex items-center space-x-3">
                    <form action="{{ route('admin.settings.clear-cache') }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" class="btn-secondary px-4 py-2">
                            🗑️ Clear Cache
                        </button>
                    </form>
                    <a href="{{ route('home') }}" class="btn-secondary px-4 py-2">
                        ← Back to Site
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="py-8">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="mb-8">
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Platform Configuration</h1>
                <p class="text-gray-400 mt-2">Configure all platform settings and integrations</p>
            </div>

            <!-- Statistics Cards -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
                <div class="gaming-card rounded-lg p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                                <span class="text-xl text-black">⚙️</span>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold text-cod-green">{{ number_format($stats['total_settings']) }}</h3>
                                <p class="text-gray-400">Total Settings</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="gaming-card rounded-lg p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                                <span class="text-xl text-black">💳</span>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold text-cod-green">{{ number_format($stats['payment_gateways']) }}</h3>
                                <p class="text-gray-400">Payment Gateways</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="gaming-card rounded-lg p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                                <span class="text-xl text-black">🔒</span>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold text-cod-green">{{ number_format($stats['security_settings']) }}</h3>
                                <p class="text-gray-400">Security Settings</p>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="gaming-card rounded-lg p-6">
                    <div class="flex items-center justify-between mb-4">
                        <div class="flex items-center space-x-3">
                            <div class="w-12 h-12 bg-cod-green rounded-lg flex items-center justify-center">
                                <span class="text-xl text-black">🔐</span>
                            </div>
                            <div>
                                <h3 class="text-2xl font-bold text-cod-green">{{ number_format($stats['encrypted_settings']) }}</h3>
                                <p class="text-gray-400">Encrypted Settings</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Settings Groups -->
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                @foreach($groups as $groupKey => $groupTitle)
                <div class="gaming-card rounded-lg p-6 hover:shadow-2xl transition-all duration-300">
                    <div class="flex items-center space-x-4 mb-4">
                        <div class="w-16 h-16 rounded-lg flex items-center justify-center"
                             style="background: linear-gradient(135deg, #00FF21 0%, #00CC1A 100%);">
                            <span class="text-2xl text-black">
                                @switch($groupKey)
                                    @case('general')
                                        🏠
                                        @break
                                    @case('payment')
                                        💳
                                        @break
                                    @case('security')
                                        🔒
                                        @break
                                    @case('platform')
                                        ⚙️
                                        @break
                                    @case('features')
                                        🎮
                                        @break
                                @endswitch
                            </span>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold text-cod-green">{{ $groupTitle }}</h3>
                            <p class="text-gray-400 text-sm">
                                @switch($groupKey)
                                    @case('general')
                                        Basic platform information
                                        @break
                                    @case('payment')
                                        Payment gateway configurations
                                        @break
                                    @case('security')
                                        Security and authentication settings
                                        @break
                                    @case('platform')
                                        Platform-specific configurations
                                        @break
                                    @case('features')
                                        Feature toggles and controls
                                        @break
                                @endswitch
                            </p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        <p class="text-gray-300 text-sm">
                            @switch($groupKey)
                                @case('general')
                                    Configure platform name, description, contact details, and basic settings.
                                    @break
                                @case('payment')
                                    Set up payment gateways like Paystack, Flutterwave, PayPal, and Stripe.
                                    @break
                                @case('security')
                                    Manage security settings, rate limiting, and authentication controls.
                                    @break
                                @case('platform')
                                    Configure commission rates, deposit/withdrawal limits, and KYC requirements.
                                    @break
                                @case('features')
                                    Enable or disable platform features like challenges, tournaments, and wallets.
                                    @break
                            @endswitch
                        </p>

                        <a href="{{ route('admin.settings.group', $groupKey) }}" 
                           class="inline-flex items-center justify-center w-full px-4 py-2 bg-cod-green hover:bg-green-600 text-black font-medium rounded-lg transition-colors">
                            Configure {{ $groupTitle }}
                            <span class="ml-2">→</span>
                        </a>
                    </div>
                </div>
                @endforeach
            </div>

            <!-- Quick Actions -->
            <div class="mt-8">
                <h2 class="text-xl font-bold text-cod-green mb-4">Quick Actions</h2>
                <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                    <form action="{{ route('admin.settings.clear-cache') }}" method="POST" class="gaming-card rounded-lg p-4">
                        @csrf
                        <div class="flex items-center space-x-3 mb-3">
                            <div class="w-10 h-10 bg-red-600 rounded-lg flex items-center justify-center">
                                <span class="text-white">🗑️</span>
                            </div>
                            <div>
                                <h3 class="font-bold text-white">Clear All Caches</h3>
                                <p class="text-gray-400 text-sm">Clear application caches</p>
                            </div>
                        </div>
                        <button type="submit" class="w-full btn-danger">Clear Cache</button>
                    </form>

                    <div class="gaming-card rounded-lg p-4">
                        <div class="flex items-center space-x-3 mb-3">
                            <div class="w-10 h-10 bg-blue-600 rounded-lg flex items-center justify-center">
                                <span class="text-white">📧</span>
                            </div>
                            <div>
                                <h3 class="font-bold text-white">Test Email</h3>
                                <p class="text-gray-400 text-sm">Send test email</p>
                            </div>
                        </div>
                        <button onclick="testConfiguration('mail')" class="w-full btn-secondary">Test Email</button>
                    </div>

                    <div class="gaming-card rounded-lg p-4">
                        <div class="flex items-center space-x-3 mb-3">
                            <div class="w-10 h-10 bg-green-600 rounded-lg flex items-center justify-center">
                                <span class="text-white">💳</span>
                            </div>
                            <div>
                                <h3 class="font-bold text-white">Test Payment</h3>
                                <p class="text-gray-400 text-sm">Test payment gateway</p>
                            </div>
                        </div>
                        <button onclick="testConfiguration('payment', 'paystack')" class="w-full btn-secondary">Test Payment</button>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function testConfiguration(type, provider = null) {
    const formData = new FormData();
    formData.append('type', type);
    if (provider) formData.append('provider', provider);

    fetch('{{ route("admin.settings.test") }}', {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            alert('✅ ' + data.message);
        } else {
            alert('❌ ' + data.message);
        }
    })
    .catch(error => {
        alert('❌ Test failed: ' + error.message);
    });
}
</script>
@endsection