@extends('layouts.app')

@section('title', 'Create Tournament')

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="mb-8">
            <div class="flex items-center space-x-4 mb-4">
                <a href="{{ route('admin.tournaments.index') }}" class="btn-secondary px-4 py-2">
                    ← Back to Tournaments
                </a>
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Create Tournament</h1>
            </div>
            <p class="text-gray-400">Create a new tournament for players to compete</p>
        </div>

        <div class="gaming-card rounded-lg p-8">
            <form action="{{ route('admin.tournaments.store') }}" method="POST" class="space-y-6">
                @csrf

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="title" class="block text-sm font-medium text-cod-green mb-2">Tournament Title</label>
                        <input type="text" 
                               id="title" 
                               name="title" 
                               value="{{ old('title') }}"
                               class="gaming-input w-full @error('title') border-red-500 @enderror"
                               placeholder="e.g., CODM Championship 2024"
                               required>
                        @error('title')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="game_id" class="block text-sm font-medium text-cod-green mb-2">Game</label>
                        <select id="game_id" 
                                name="game_id" 
                                class="gaming-select w-full @error('game_id') border-red-500 @enderror"
                                required>
                            <option value="">Select Game</option>
                            @foreach($games as $game)
                                <option value="{{ $game->id }}" {{ old('game_id') == $game->id ? 'selected' : '' }}>
                                    {{ $game->name }} ({{ $game->platform }})
                                </option>
                            @endforeach
                        </select>
                        @error('game_id')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="host_id" class="block text-sm font-medium text-cod-green mb-2">Tournament Host</label>
                        <select id="host_id" 
                                name="host_id" 
                                class="gaming-select w-full @error('host_id') border-red-500 @enderror"
                                required>
                            <option value="">Select Host</option>
                            @foreach($hosts as $host)
                                <option value="{{ $host->id }}" {{ old('host_id') == $host->id ? 'selected' : '' }}>
                                    {{ $host->username }}
                                </option>
                            @endforeach
                        </select>
                        @error('host_id')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="type" class="block text-sm font-medium text-cod-green mb-2">Tournament Type</label>
                        <select id="type" 
                                name="type" 
                                class="gaming-select w-full @error('type') border-red-500 @enderror"
                                required>
                            <option value="">Select Type</option>
                            <option value="single_elimination" {{ old('type') == 'single_elimination' ? 'selected' : '' }}>Single Elimination</option>
                            <option value="double_elimination" {{ old('type') == 'double_elimination' ? 'selected' : '' }}>Double Elimination</option>
                            <option value="round_robin" {{ old('type') == 'round_robin' ? 'selected' : '' }}>Round Robin</option>
                        </select>
                        @error('type')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div>
                    <label for="description" class="block text-sm font-medium text-cod-green mb-2">Description</label>
                    <textarea id="description" 
                              name="description" 
                              rows="4"
                              class="gaming-textarea w-full @error('description') border-red-500 @enderror"
                              placeholder="Describe the tournament rules, format, and requirements..."
                              required>{{ old('description') }}</textarea>
                    @error('description')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="entry_fee" class="block text-sm font-medium text-cod-green mb-2">Entry Fee (₦)</label>
                        <input type="number" 
                               id="entry_fee" 
                               name="entry_fee" 
                               value="{{ old('entry_fee', '0') }}"
                               min="0"
                               step="0.01"
                               class="gaming-input w-full @error('entry_fee') border-red-500 @enderror"
                               placeholder="0.00">
                        @error('entry_fee')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="prize_pool" class="block text-sm font-medium text-cod-green mb-2">Prize Pool (₦)</label>
                        <input type="number" 
                               id="prize_pool" 
                               name="prize_pool" 
                               value="{{ old('prize_pool', '0') }}"
                               min="0"
                               step="0.01"
                               class="gaming-input w-full @error('prize_pool') border-red-500 @enderror"
                               placeholder="0.00">
                        @error('prize_pool')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div>
                    <label for="livestream_link" class="block text-sm font-medium text-cod-green mb-2">Livestream Link (Optional)</label>
                    <input type="url" 
                           id="livestream_link" 
                           name="livestream_link" 
                           value="{{ old('livestream_link') }}"
                           class="gaming-input w-full @error('livestream_link') border-red-500 @enderror"
                           placeholder="https://youtube.com/watch?v=...">
                    @error('livestream_link')
                        <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div>
                        <label for="starts_at" class="block text-sm font-medium text-cod-green mb-2">Start Date & Time</label>
                        <input type="datetime-local" 
                               id="starts_at" 
                               name="starts_at" 
                               value="{{ old('starts_at') }}"
                               class="gaming-input w-full @error('starts_at') border-red-500 @enderror"
                               required>
                        @error('starts_at')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>

                    <div>
                        <label for="ends_at" class="block text-sm font-medium text-cod-green mb-2">End Date & Time</label>
                        <input type="datetime-local" 
                               id="ends_at" 
                               name="ends_at" 
                               value="{{ old('ends_at') }}"
                               class="gaming-input w-full @error('ends_at') border-red-500 @enderror"
                               required>
                        @error('ends_at')
                            <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                        @enderror
                    </div>
                </div>

                <div class="flex justify-end space-x-4 pt-6">
                    <a href="{{ route('admin.tournaments.index') }}" class="btn-secondary px-6 py-3">
                        Cancel
                    </a>
                    <button type="submit" class="gaming-button px-6 py-3 rounded-lg">
                        Create Tournament
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>
@endsection