@extends('layouts.admin')

@section('title', 'Tournament Management')
@section('page-title', 'Tournament Management')
@section('page-subtitle', 'Manage tournaments and competitive events')

@section('content')
<div class="p-6">
    <div class="max-w-7xl mx-auto">
        <div class="flex justify-between items-center mb-8">
            <div>
                <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">Tournament Management</h1>
                <p class="text-gray-400 mt-2">Manage tournaments and competitions</p>
            </div>
            <a href="{{ route('admin.tournaments.create') }}" class="gaming-button px-6 py-3 rounded-lg">
                Create Tournament
            </a>
        </div>

        <div class="gaming-card rounded-lg p-6">
            <div class="overflow-x-auto">
                <table class="gaming-table w-full">
                    <thead>
                        <tr>
                            <th class="text-left">Tournament</th>
                            <th class="text-left">Game</th>
                            <th class="text-left">Host</th>
                            <th class="text-center">Entry Fee</th>
                            <th class="text-center">Participants</th>
                            <th class="text-center">Status</th>
                            <th class="text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($tournaments as $tournament)
                            <tr>
                                <td>
                                    <div>
                                        <div class="font-medium text-white">{{ $tournament->title }}</div>
                                        <div class="text-sm text-gray-400">{{ $tournament->type }}</div>
                                    </div>
                                </td>
                                <td>
                                    <div class="flex items-center space-x-2">
                                        <div class="w-8 h-8 bg-cod-green rounded-lg flex items-center justify-center">
                                            <span class="text-xs font-bold text-black">{{ substr($tournament->game->name, 0, 1) }}</span>
                                        </div>
                                        <span class="text-white">{{ $tournament->game->name }}</span>
                                    </div>
                                </td>
                                <td class="text-white">{{ $tournament->host->username }}</td>
                                <td class="text-center text-cod-green">₦{{ number_format($tournament->entry_fee, 2) }}</td>
                                <td class="text-center text-cod-green">{{ $tournament->participants_count }}</td>
                                <td class="text-center">
                                    <span class="status-badge status-{{ $tournament->status }}">{{ ucfirst($tournament->status) }}</span>
                                </td>
                                <td class="text-center">
                                    <div class="flex justify-center space-x-2">
                                        <a href="{{ route('admin.tournaments.show', $tournament) }}" class="btn-secondary px-3 py-1 text-xs">
                                            View
                                        </a>
                                        <a href="{{ route('admin.tournaments.edit', $tournament) }}" class="btn-secondary px-3 py-1 text-xs">
                                            Edit
                                        </a>
                                        <a href="{{ route('admin.tournaments.participants', $tournament) }}" class="btn-secondary px-3 py-1 text-xs">
                                            Participants
                                        </a>
                                    </div>
                                </td>
                            </tr>
                        @empty
                            <tr>
                                <td colspan="7" class="text-center py-8">
                                    <div class="text-gray-400">
                                        <svg class="w-12 h-12 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                                        </svg>
                                        <p>No tournaments found. Create your first tournament!</p>
                                    </div>
                                </td>
                            </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            @if($tournaments->hasPages())
                <div class="mt-6">
                    {{ $tournaments->links() }}
                </div>
            @endif
        </div>
    </div>
</div>
@endsection