@extends('layouts.app')

@section('title', 'Tournament Participants')

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="mb-8">
            <div class="flex items-center space-x-4 mb-4">
                <a href="{{ route('admin.tournaments.index') }}" class="btn-secondary px-4 py-2">
                    ← Back to Tournaments
                </a>
                <div>
                    <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">{{ $tournament->title }}</h1>
                    <p class="text-gray-400">Manage tournament participants</p>
                </div>
            </div>
        </div>

        <!-- Tournament Info -->
        <div class="gaming-card rounded-lg p-6 mb-8">
            <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">{{ $tournament->game->name }}</div>
                    <div class="text-sm text-gray-400">Game</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">₦{{ number_format($tournament->entry_fee, 2) }}</div>
                    <div class="text-sm text-gray-400">Entry Fee</div>
                </div>
                <div class="text-center">
                    <div class="text-2xl font-bold text-cod-green">{{ $participants->count() }}</div>
                    <div class="text-sm text-gray-400">Participants</div>
                </div>
                <div class="text-center">
                    <span class="status-badge status-{{ $tournament->status }}">{{ ucfirst($tournament->status) }}</span>
                    <div class="text-sm text-gray-400 mt-2">Status</div>
                </div>
            </div>

            @if($tournament->status === 'upcoming')
                <div class="flex justify-center space-x-4 mt-6">
                    @if($participants->count() >= 2)
                        <form action="{{ route('admin.tournaments.start', $tournament) }}" method="POST" class="inline">
                            @csrf
                            <button type="submit" class="gaming-button px-6 py-3 rounded-lg" 
                                    onclick="return confirm('Are you sure you want to start this tournament?')">
                                Start Tournament
                            </button>
                        </form>
                    @else
                        <div class="text-yellow-400 text-sm">Need at least 2 participants to start</div>
                    @endif
                </div>
            @elseif($tournament->status === 'ongoing')
                <div class="flex justify-center space-x-4 mt-6">
                    <form action="{{ route('admin.tournaments.complete', $tournament) }}" method="POST" class="inline">
                        @csrf
                        <button type="submit" class="gaming-button px-6 py-3 rounded-lg" 
                                onclick="return confirm('Are you sure you want to complete this tournament?')">
                            Complete Tournament
                        </button>
                    </form>
                </div>
            @endif
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- Current Participants -->
            <div class="gaming-card rounded-lg p-6">
                <h2 class="text-xl font-semibold text-cod-green mb-6">Current Participants</h2>
                
                @if($participants->count() > 0)
                    <div class="space-y-4">
                        @foreach($participants as $participant)
                            <div class="flex items-center justify-between p-4 bg-cod-gray rounded-lg">
                                <div class="flex items-center space-x-3">
                                    <div class="w-10 h-10 bg-cod-green rounded-full flex items-center justify-center">
                                        <span class="text-sm font-bold text-black">{{ substr($participant->user->username, 0, 1) }}</span>
                                    </div>
                                    <div>
                                        <div class="font-medium text-white">{{ $participant->user->username }}</div>
                                        <div class="text-sm text-gray-400">
                                            Seed #{{ $participant->seed }} • Level {{ $participant->user->level }}
                                        </div>
                                    </div>
                                </div>
                                
                                @if($tournament->status === 'upcoming')
                                    <form action="{{ route('admin.tournaments.participants.remove', [$tournament, $participant]) }}" method="POST" class="inline">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn-danger px-3 py-1 text-xs" 
                                                onclick="return confirm('Remove this participant? They will be refunded.')">
                                            Remove
                                        </button>
                                    </form>
                                @else
                                    @if($participant->result)
                                        <span class="status-badge status-completed">{{ ucfirst(str_replace('_', ' ', $participant->result)) }}</span>
                                    @else
                                        <span class="text-gray-400 text-sm">Playing</span>
                                    @endif
                                @endif
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-8 text-gray-400">
                        <svg class="w-12 h-12 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"></path>
                        </svg>
                        <p>No participants yet</p>
                    </div>
                @endif
            </div>

            <!-- Add Participants -->
            @if($tournament->status === 'upcoming')
                <div class="gaming-card rounded-lg p-6">
                    <h2 class="text-xl font-semibold text-cod-green mb-6">Add Participants</h2>
                    
                    @if($availableUsers->count() > 0)
                        <form action="{{ route('admin.tournaments.participants.add', $tournament) }}" method="POST">
                            @csrf
                            <div class="space-y-4">
                                <div>
                                    <label for="user_id" class="block text-sm font-medium text-cod-green mb-2">Select User</label>
                                    <select id="user_id" name="user_id" class="gaming-select w-full" required>
                                        <option value="">Choose a user to add...</option>
                                        @foreach($availableUsers as $user)
                                            <option value="{{ $user->id }}">
                                                {{ $user->username }} 
                                                (₦{{ number_format($user->wallet_balance, 2) }}) 
                                                - Level {{ $user->level }}
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                
                                <button type="submit" class="gaming-button w-full py-3 rounded-lg">
                                    Add Participant
                                </button>
                            </div>
                        </form>
                        
                        <div class="mt-6 p-4 bg-cod-gray rounded-lg">
                            <h3 class="text-sm font-medium text-cod-green mb-2">💡 Selection Criteria</h3>
                            <ul class="text-xs text-gray-400 space-y-1">
                                <li>• Users must have sufficient balance (₦{{ number_format($tournament->entry_fee, 2) }})</li>
                                <li>• Users cannot already be participating</li>
                                <li>• Entry fee will be automatically deducted</li>
                            </ul>
                        </div>
                    @else
                        <div class="text-center py-8 text-gray-400">
                            <p>No eligible users available</p>
                            <p class="text-sm mt-2">All users either lack sufficient balance or are already participating</p>
                        </div>
                    @endif
                </div>
            @endif
        </div>
    </div>
</div>
@endsection