@extends('layouts.app')

@section('title', 'Tournament Details')

@section('content')
<div class="min-h-screen bg-cod-darker py-8">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="mb-8">
            <div class="flex items-center justify-between mb-4">
                <div class="flex items-center space-x-4">
                    <a href="{{ route('admin.tournaments.index') }}" class="btn-secondary px-4 py-2">
                        ← Back to Tournaments
                    </a>
                    <div>
                        <h1 class="text-3xl font-gaming font-bold text-cod-green gaming-text-glow">{{ $tournament->title }}</h1>
                        <p class="text-gray-400">Tournament details and management</p>
                    </div>
                </div>
                <div class="flex space-x-3">
                    <a href="{{ route('admin.tournaments.edit', $tournament) }}" class="gaming-button px-4 py-2 rounded-lg">
                        Edit Tournament
                    </a>
                    <a href="{{ route('admin.tournaments.participants', $tournament) }}" class="btn-secondary px-4 py-2">
                        Manage Participants
                    </a>
                </div>
            </div>
        </div>

        <!-- Tournament Overview -->
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8 mb-8">
            <div class="lg:col-span-2 gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Tournament Information</h3>
                <div class="space-y-4">
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <span class="text-gray-400 text-sm">Game:</span>
                            <div class="text-white font-medium">{{ $tournament->game->name }}</div>
                        </div>
                        <div>
                            <span class="text-gray-400 text-sm">Platform:</span>
                            <div class="text-white font-medium">{{ $tournament->game->platform }}</div>
                        </div>
                    </div>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <div>
                            <span class="text-gray-400 text-sm">Type:</span>
                            <div class="text-white font-medium">{{ ucfirst(str_replace('_', ' ', $tournament->type)) }}</div>
                        </div>
                        <div>
                            <span class="text-gray-400 text-sm">Host:</span>
                            <div class="text-white font-medium">{{ $tournament->host->username }}</div>
                        </div>
                    </div>

                    <div>
                        <span class="text-gray-400 text-sm">Description:</span>
                        <div class="text-white mt-1 p-3 bg-cod-gray rounded-lg">{{ $tournament->description }}</div>
                    </div>

                    @if($tournament->livestream_link)
                        <div>
                            <span class="text-gray-400 text-sm">Livestream:</span>
                            <div class="mt-1">
                                <a href="{{ $tournament->livestream_link }}" target="_blank" 
                                   class="text-cod-green hover:text-green-400 break-all">
                                    {{ $tournament->livestream_link }}
                                </a>
                            </div>
                        </div>
                    @endif
                </div>
            </div>

            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Tournament Stats</h3>
                <div class="space-y-4">
                    <div class="text-center">
                        <div class="text-2xl font-bold text-cod-green">{{ $tournament->participants->count() }}</div>
                        <div class="text-sm text-gray-400">Participants</div>
                    </div>
                    
                    <div class="text-center">
                        <div class="text-2xl font-bold text-cod-green">₦{{ number_format($tournament->entry_fee, 2) }}</div>
                        <div class="text-sm text-gray-400">Entry Fee</div>
                    </div>
                    
                    <div class="text-center">
                        <div class="text-2xl font-bold text-cod-green">₦{{ number_format($tournament->prize_pool, 2) }}</div>
                        <div class="text-sm text-gray-400">Prize Pool</div>
                    </div>
                    
                    <div class="text-center">
                        <span class="status-badge status-{{ $tournament->status }}">{{ ucfirst($tournament->status) }}</span>
                        <div class="text-sm text-gray-400 mt-2">Status</div>
                    </div>

                    <div class="text-center">
                        <div class="text-sm text-gray-400">Start Time</div>
                        <div class="text-white font-medium">{{ $tournament->starts_at->format('M j, Y g:i A') }}</div>
                    </div>

                    <div class="text-center">
                        <div class="text-sm text-gray-400">End Time</div>
                        <div class="text-white font-medium">{{ $tournament->ends_at->format('M j, Y g:i A') }}</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Participants -->
        <div class="gaming-card rounded-lg p-6 mb-8">
            <div class="flex justify-between items-center mb-6">
                <h3 class="text-lg font-semibold text-cod-green">Participants ({{ $tournament->participants->count() }})</h3>
                <a href="{{ route('admin.tournaments.participants', $tournament) }}" class="btn-secondary px-4 py-2">
                    Manage Participants
                </a>
            </div>
            
            @if($tournament->participants->count() > 0)
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($tournament->participants as $participant)
                        <div class="gaming-card rounded-lg p-4">
                            <div class="flex items-center space-x-3">
                                <div class="w-10 h-10 bg-cod-green rounded-full flex items-center justify-center">
                                    <span class="text-sm font-bold text-black">{{ substr($participant->user->username, 0, 1) }}</span>
                                </div>
                                <div>
                                    <div class="font-medium text-white">{{ $participant->user->username }}</div>
                                    <div class="text-sm text-gray-400">
                                        Seed #{{ $participant->seed }} • Level {{ $participant->user->level }}
                                    </div>
                                </div>
                            </div>
                            @if($participant->result)
                                <div class="mt-2">
                                    <span class="status-badge status-completed">{{ ucfirst(str_replace('_', ' ', $participant->result)) }}</span>
                                </div>
                            @endif
                        </div>
                    @endforeach
                </div>
            @else
                <div class="text-center py-8 text-gray-400">
                    <svg class="w-12 h-12 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.25 2.25 0 11-4.5 0 2.25 2.25 0 014.5 0z"></path>
                    </svg>
                    <p>No participants registered yet</p>
                </div>
            @endif
        </div>

        <!-- Tournament Matches -->
        @if($tournament->matches->count() > 0)
            <div class="gaming-card rounded-lg p-6">
                <h3 class="text-lg font-semibold text-cod-green mb-6">Tournament Matches</h3>
                <div class="overflow-x-auto">
                    <table class="gaming-table w-full">
                        <thead>
                            <tr>
                                <th class="text-left">Round</th>
                                <th class="text-left">Match</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Winner</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($tournament->matches as $match)
                                <tr>
                                    <td class="text-white">{{ $match->round }}</td>
                                    <td class="text-white">{{ $match->description ?? 'Match ' . $match->id }}</td>
                                    <td class="text-center">
                                        <span class="status-badge status-{{ $match->status ?? 'pending' }}">
                                            {{ ucfirst($match->status ?? 'Pending') }}
                                        </span>
                                    </td>
                                    <td class="text-center text-gray-400">
                                        {{ $match->winner_id ? 'Player #' . $match->winner_id : 'TBD' }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        @endif
    </div>
</div>
@endsection