@extends('layouts.app')

@section('title', 'Register')

@section('content')
<div class="min-h-screen flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full space-y-8">
        <div class="text-center">
            <div class="animate-float">
                <div class="w-20 h-20 bg-gradient-to-br from-cod-green to-cod-green-dark rounded-2xl mx-auto mb-6 flex items-center justify-center">
                    <span class="text-3xl font-bold text-black">⚔️</span>
                </div>
                <h2 class="text-4xl font-gaming font-extrabold text-cod-green gaming-text-glow">
                    Join the Battle
                </h2>
                <p class="mt-2 text-sm text-gray-400">
                    Create your gaming account and start competing
                </p>
            </div>
        </div>
        
        <form class="mt-8 space-y-8 bg-cod-gray p-8 rounded-xl gaming-glow border border-cod-green/20" method="POST" action="{{ route('register') }}">
            @csrf

            <div class="space-y-6">
                <!-- Username with Floating Label -->
                <div class="floating-label-group">
                    <input id="username" 
                           name="username" 
                           type="text" 
                           autocomplete="username" 
                           required
                           value="{{ old('username') }}"
                           placeholder="Your gamer tag"
                           class="floating-label-input {{ $errors->has('username') ? 'form-error' : '' }}">
                    <label for="username" class="floating-label">Username *</label>
                    @error('username')
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror
                    <div class="text-xs text-gray-400 mt-1">
                        Choose a unique gamer tag (3-20 characters)
                    </div>
                </div>

                <!-- Email Address with Floating Label -->
                <div class="floating-label-group">
                    <input id="email" 
                           name="email" 
                           type="email" 
                           autocomplete="email" 
                           required
                           value="{{ old('email') }}"
                           placeholder="your.email@example.com"
                           class="floating-label-input {{ $errors->has('email') ? 'form-error' : '' }}">
                    <label for="email" class="floating-label">Email Address *</label>
                    @error('email')
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror
                </div>

                <!-- Password with Floating Label -->
                <div class="floating-label-group">
                    <input id="password" 
                           name="password" 
                           type="password" 
                           autocomplete="new-password" 
                           required
                           placeholder="Create a strong password"
                           class="floating-label-input {{ $errors->has('password') ? 'form-error' : '' }}">
                    <label for="password" class="floating-label">Password *</label>
                    @error('password')
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror
                    <div class="text-xs text-gray-400 mt-1">
                        Minimum 8 characters with letters and numbers
                    </div>
                </div>

                <!-- Confirm Password with Floating Label -->
                <div class="floating-label-group">
                    <input id="password_confirmation" 
                           name="password_confirmation" 
                           type="password" 
                           autocomplete="new-password" 
                           required
                           placeholder="Confirm your password"
                           class="floating-label-input {{ $errors->has('password_confirmation') ? 'form-error' : '' }}">
                    <label for="password_confirmation" class="floating-label">Confirm Password *</label>
                    @error('password_confirmation')
                        <div class="error-message">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                            </svg>
                            <span>{{ $message }}</span>
                        </div>
                    @enderror
                </div>

                <!-- Terms and Conditions -->
                <div class="flex items-start space-x-3">
                    <div class="flex items-center h-5">
                        <input id="terms" 
                               name="terms" 
                               type="checkbox" 
                               required
                               class="h-4 w-4 bg-cod-dark border border-cod-light rounded focus:ring-cod-green focus:ring-2 text-cod-green transition-colors">
                    </div>
                    <div class="text-sm">
                        <label for="terms" class="text-gray-300">
                            I agree to the 
                            <a href="{{ route('terms-of-service') }}" class="text-cod-green hover:text-green-400 transition-colors" target="_blank">
                                Terms of Service
                            </a> 
                            and 
                            <a href="{{ route('privacy-policy') }}" class="text-cod-green hover:text-green-400 transition-colors" target="_blank">
                                Privacy Policy
                            </a>
                        </label>
                    </div>
                </div>
            </div>

            <!-- Register Button -->
            <div>
                <button type="submit" class="btn-primary-modern w-full">
                    <span class="flex items-center justify-center space-x-2">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M18 9v3m0 0v3m0-3h3m-3 0h-3m-2-5a4 4 0 11-8 0 4 4 0 018 0zM3 20a6 6 0 0112 0v1H3v-1z"></path>
                        </svg>
                        <span>Create Account</span>
                    </span>
                </button>
            </div>

            <!-- Social Registration Options -->
            <div class="mt-6">
                <div class="relative">
                    <div class="absolute inset-0 flex items-center">
                        <div class="w-full border-t border-cod-light"></div>
                    </div>
                    <div class="relative flex justify-center text-sm">
                        <span class="px-2 bg-cod-gray text-gray-400">Or continue with</span>
                    </div>
                </div>

                <div class="mt-6 text-center">
                    <p class="text-sm text-gray-400">
                        Already have an account?
                        <a href="{{ route('login') }}" class="text-cod-green hover:text-green-400 font-medium transition-colors">
                            Sign in here
                        </a>
                    </p>
                </div>
            </div>
        </form>

        <!-- Additional Info -->
        <div class="text-center">
            <div class="bg-cod-dark/50 rounded-lg p-4 border border-cod-green/10">
                <h4 class="text-sm font-bold text-cod-green mb-2">🎮 What You Get</h4>
                <div class="text-xs text-gray-400 space-y-1">
                    <div>✓ Compete in 1v1 challenges</div>
                    <div>✓ Join exclusive tournaments</div>
                    <div>✓ Earn real money prizes</div>
                    <div>✓ Track your gaming progress</div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Enhanced form validation
    document.addEventListener('DOMContentLoaded', function() {
        const form = document.querySelector('form');
        const inputs = form.querySelectorAll('input[type="text"], input[type="email"], input[type="password"]');
        const passwordInput = document.getElementById('password');
        const confirmPasswordInput = document.getElementById('password_confirmation');

        inputs.forEach(input => {
            input.addEventListener('blur', function() {
                validateField(this);
            });

            input.addEventListener('input', function() {
                if (this.classList.contains('form-error')) {
                    validateField(this);
                }
                
                // Real-time password confirmation check
                if (this === confirmPasswordInput && passwordInput.value) {
                    validatePasswordMatch();
                }
            });
        });

        function validateField(field) {
            const value = field.value.trim();
            const isRequired = field.hasAttribute('required');

            // Remove existing validation classes
            field.classList.remove('form-error', 'form-success');

            if (isRequired && !value) {
                field.classList.add('form-error');
            } else if (value) {
                // Specific validation rules
                if (field.type === 'email' && !isValidEmail(value)) {
                    field.classList.add('form-error');
                } else if (field.name === 'password' && value.length < 8) {
                    field.classList.add('form-error');
                } else {
                    field.classList.add('form-success');
                }
            }
        }

        function validatePasswordMatch() {
            if (passwordInput.value !== confirmPasswordInput.value) {
                confirmPasswordInput.classList.remove('form-success');
                confirmPasswordInput.classList.add('form-error');
            } else {
                confirmPasswordInput.classList.remove('form-error');
                confirmPasswordInput.classList.add('form-success');
            }
        }

        function isValidEmail(email) {
            const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
            return emailRegex.test(email);
        }
    });
</script>
@endsection