@extends('layouts.app')

@section('title', 'Invite Friends to Challenge')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <!-- Header -->
    <div class="mb-8">
        <h1 class="text-3xl font-gaming font-bold text-cod-green mb-2">Invite Friends to Challenge</h1>
        <p class="text-gray-400">Select friends to invite to your {{ $challenge->game->name }} challenge</p>
    </div>

    <!-- Challenge Info -->
    <div class="bg-cod-gray rounded-lg p-6 mb-8">
        <div class="flex justify-between items-start mb-4">
            <div>
                <h2 class="text-xl font-semibold text-cod-green">{{ $challenge->game->name }} Challenge</h2>
                <p class="text-gray-400">Best of {{ $challenge->best_of }}</p>
            </div>
            <div class="text-right">
                <div class="text-2xl font-bold text-green-400">₦{{ number_format($challenge->wager_amount) }}</div>
                <div class="text-sm text-gray-400">per player</div>
            </div>
        </div>
        
        @if($challenge->rules_text)
            <div class="bg-cod-dark rounded p-4">
                <h3 class="text-sm font-semibold text-gray-300 mb-2">Rules:</h3>
                <p class="text-gray-400 text-sm">{{ $challenge->rules_text }}</p>
            </div>
        @endif
    </div>

    @if($friends->count() > 0)
        <!-- Invite Form -->
        <form method="POST" action="{{ route('challenges.invite.send', $challenge) }}">
            @csrf
            
            <!-- Friends Selection -->
            <div class="bg-cod-gray rounded-lg p-6 mb-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Select Friends to Invite</h3>
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                    @foreach($friends as $friend)
                        <div class="bg-cod-dark rounded-lg p-4">
                            <div class="flex items-center space-x-3 mb-3">
                                <input type="checkbox" name="invitees[]" value="{{ $friend->id }}" 
                                       class="w-4 h-4 text-cod-green bg-cod-light border-cod-green rounded focus:ring-cod-green"
                                       id="friend_{{ $friend->id }}">
                                <div class="w-10 h-10 bg-cod-green rounded-full flex items-center justify-center">
                                    <span class="text-black font-bold text-sm">{{ substr($friend->username, 0, 2) }}</span>
                                </div>
                                <label for="friend_{{ $friend->id }}" class="cursor-pointer">
                                    <h4 class="font-semibold text-gray-100">{{ $friend->username }}</h4>
                                    <p class="text-sm text-gray-400">Level {{ $friend->level }}</p>
                                </label>
                            </div>
                            
                            <!-- Friend Stats -->
                            <div class="text-xs text-gray-500 space-y-1">
                                <div class="flex justify-between">
                                    <span>Wins:</span>
                                    <span class="text-green-400">{{ $friend->createdChallenges()->where('result', 'creator_win')->count() + $friend->acceptedChallenges()->where('result', 'accepter_win')->count() }}</span>
                                </div>
                                <div class="flex justify-between">
                                    <span>Balance:</span>
                                    <span class="text-gray-300">₦{{ number_format($friend->wallet_balance) }}</span>
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>

            <!-- Message -->
            <div class="bg-cod-gray rounded-lg p-6 mb-6">
                <h3 class="text-lg font-semibold text-cod-green mb-4">Optional Message</h3>
                <textarea 
                    name="message" 
                    rows="4" 
                    class="w-full bg-cod-dark text-gray-100 border border-cod-light rounded-lg px-4 py-3 resize-none focus:border-cod-green focus:outline-none"
                    placeholder="Add a personal message to your invite..."
                >{{ old('message') }}</textarea>
            </div>

            <!-- Actions -->
            <div class="flex space-x-4">
                <button type="submit" class="bg-cod-green text-black px-8 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Send Invites
                </button>
                <a href="{{ route('challenges.show', $challenge) }}" class="bg-cod-light text-cod-green px-8 py-3 rounded-lg font-semibold hover:bg-cod-green hover:text-black transition-colors">
                    Cancel
                </a>
            </div>
        </form>
    @else
        <!-- No Friends -->
        <div class="bg-cod-gray rounded-lg p-8 text-center">
            <div class="text-6xl mb-4">👥</div>
            <h3 class="text-xl font-semibold text-gray-400 mb-2">No Friends to Invite</h3>
            <p class="text-gray-500 mb-6">You need friends to send challenge invites. Start building your friend network!</p>
            <div class="space-x-4">
                <a href="{{ route('friends.suggestions') }}" class="inline-block bg-cod-green text-black px-6 py-3 rounded-lg font-semibold hover:bg-green-600 transition-colors">
                    Find Friends
                </a>
                <a href="{{ route('challenges.show', $challenge) }}" class="inline-block bg-cod-light text-cod-green px-6 py-3 rounded-lg font-semibold hover:bg-cod-green hover:text-black transition-colors">
                    Back to Challenge
                </a>
            </div>
        </div>
    @endif
</div>
@endsection